Review

# Review on Nanoparticles and Nanostructured Materials: Bioimaging, Biosensing, Drug Delivery, Tissue Engineering, Antimicrobial, and Agro-Food Applications

Vancha Harish ${ \bf 1 } _ { \textcircled { | \mathbb { D } } }$ , Devesh Tewari $\mathbf { 1 } _ { \textcircled { 1 0 } }$ , Manish Gaur 2, Awadh Bihari Yadav $2 , * \textcircled { \mathbb { D } }$ , Shiv Swaroop ${ } ^ { 3 } \textcircled { \vert \lbrack \cdot \vert }$ Mikhael Bechelany $4 , * \textcircled { \mathbb { D } }$ and Ahmed Barhoum $^ { 5 , 6 , * \oplus }$

Citation: Harish, V.; Tewari, D.; Gaur, M.; Yadav, A.B.; Swaroop, S.;   
Bechelany, M.; Barhoum, A. Review on Nanoparticles and   
Nanostructured Materials:   
Bioimaging, Biosensing, Drug   
Delivery, Tissue Engineering,   
Antimicrobial, and Agro-Food   
Applications. Nanomaterials 2022, 12, 457. https://doi.org/10.3390/   
nano12030457

Academic Editors: Mohammed Jaouad Meziani and Zhaohui Li

Received: 3 January 2022   
Accepted: 23 January 2022   
Published: 28 January 2022

Publisher’s Note: MDPI stays neutral with regard to jurisdictional claims in published maps and institutional affiliations.

School of Pharmaceutical Sciences, Lovely Professional University, Phagwara, Punjab 144401, India; vanchaharish@gmail.com (V.H.); dtewari3@gmail.com (D.T.)   
2 Centre of Biotechnology, University of Allahabad, Prayagraj, Uttar Pradesh 211002, India; manishgaur@allduniv.ac.in   
3 Department of Biochemistry, Central University of Rajasthan, Ajmer 305817, India; shivswaroop@curaj.ac.in   
4 Institut Européen des Membranes, IEM UMR 5635, University Montpellier, ENSCM, CNRS, 34730 Montpellier, France   
5 NanoStruc Research Group, Chemistry Department, Faculty of Science, Ain Helwan, Cairo 11795, Egypt   
6 National Centre for Sensor Research, School of Chemical Sciences, Dublin City University, D09 Y074 Dublin, Ireland   
Correspondence: awadhyadav@allduniv.ac.in (A.B.Y.); mikhael.bechelany@umontpellier.fr (M.B.); ahmed.barhoum@science.helwan.edu.eg (A.B.)

Abstract: In the last few decades, the vast potential of nanomaterials for biomedical and healthcare applications has been extensively investigated. Several case studies demonstrated that nanomaterials can offer solutions to the current challenges of raw materials in the biomedical and healthcare fields. This review describes the different nanoparticles and nanostructured material synthesis approaches and presents some emerging biomedical, healthcare, and agro-food applications. This review focuses on various nanomaterial types (e.g., spherical, nanorods, nanotubes, nanosheets, nanofibers, core-shell, and mesoporous) that can be synthesized from different raw materials and their emerging applications in bioimaging, biosensing, drug delivery, tissue engineering, antimicrobial, and agro-foods. Depending on their morphology (e.g., size, aspect ratio, geometry, porosity), nanomaterials can be used as formulation modifiers, moisturizers, nanofillers, additives, membranes, and films. As toxicological assessment depends on sizes and morphologies, stringent regulation is needed from the testing of efficient nanomaterials dosages. The challenges and perspectives for an industrial breakthrough of nanomaterials are related to the optimization of production and processing conditions.

Keywords: nanostructures; nanomaterials; drug delivery systems; tissue-engineered scaffolds; wound dressings; skincare; risks and toxicities; market and regulations

# 1. Introduction

In the last 50 years, material researchers have been extensively studying how to exploit nanoparticles and nanostructured materials in different biomedical and healthcare sectors [1]. The term $\mathbf { \omega } ^ { \prime \prime } \mathbf { N } \mathbf { P } ^ { \prime \prime }$ usually defines minute particles of matter (1 to $1 0 0 \mathrm { n m }$ in diameter), but other names can be used to describe larger particles (up to $5 0 0 \mathrm { n m }$ in diameter). For example, nanorods, nanowires, and nanofibers are nanoparticles with a diameter in the $1 { - } 1 0 0 \mathrm { n m }$ range but with one dimension outside the nanoscale dimension [2]. Nanostructured materials are nanomaterials with one dimension in the nanoscale range $( < 1 0 0 \mathrm { n m } )$ and are made of a single material or multiple materials. Therefore, nanostructured materials are composed of interlinked parts in the nanoscale range [3]. Nanoparticles and nanostructured materials can be made of simple materials (e.g., metal, carbon, polymer) [4], of composites (e.g., polymer-metal, silica-metal, graphene-metal), or in the core-shell form [5–8].

Nanomaterials are typically synthesized by one of two main approaches, i.e., bottomup approach and top-down approach. Among all the methods, recently, the synthesis of nanomaterials by physical vapor deposition, chemical vapor deposition, electrospinning, 3D printing, biological synthesis, and supercritical fluid have gained importance, which is mingled with other methods to improve the synthesis efficiency [9,10]. Nanomaterials display many interesting features, such as superior mechanical performance, the possibility of surface functionalization, large surface area, and tunable porosity, compared to their bulk materials [11–13]. These outstanding features explain why nanomaterials are the perfect candidates in the biomedical sector for the production of tissue-engineered scaffolds (e.g., blood vessels, bone), drug delivery systems (gene therapy, cancer treatments, drugs for chronic respiratory infections), chemical sensors [4,5], biosensors [6,7], and wound dressings [14,15]. Remarkably, several studies suggest that ancient civilizations in India, Egypt, and China used nanotechnology (metallic gold) for therapeutic purposes in 2500 BC [16]. Nanomaterials’ discrete features can complicate the assessment of the effects and the toxicity risk associated with their use in a biological environment. Indeed, nanomaterials’ chemical composition, size, shape, surface charge, area, and entry route in the body can influence their biological activities and effects [17].

In bioimaging, tailored fluorescent nanoparticles could outperform traditional molecular probes as fluorescent indicators, particularly in terms of sensitivity [18]. Tissueengineered nanofiber scaffolds are considered the best option to manage tissue loss and end-stage organ failure and have already helped millions of patients worldwide [15]. Threedimensional nanofibrous scaffolds are polymer-based structures with balanced moisture, absorption, strongly organized porosity $( 6 0 - 9 0 \% )$ , and gas permeability, comparable to native extracellular matrices [15]. One and two-dimensional nanomaterials can be used for signal amplification, are nanosized $\leq 1 0 0 \mathrm { n m }$ , have high electrical conductivity, and are compatible with drugs [13] and biological molecules [12]. They have also been used for the early detection of diseases (e.g., virus, bacterial, cancer). Antimicrobial nanomaterials (e.g., Ag, Au, CuO NPs) are frequently employed in dermatology because they contribute to accelerating wound healing and preventing/treating bacterial infections [19,20].

Based on dimensionality, nanomaterials are classified mainly into four groups [1]: 0D, where length, height, and width are fixed at a single point; 1D, where only one parameter exists (e.g., carbon nanotubes); 2D, where length and width exist (e.g., graphene); and 3D, where length, height, and width exist [21]. For example, a graphene nanosheet is a typical example of a 2D nanostructure with a thickness in the nanoscale range. Theoretically, single-layer graphene is $0 . 3 4 5 \mathrm { n m }$ thick (one atom thickness) and up to $5 0 0 \mathrm { n m }$ in diameter. Based on their chemical composition, nanoparticles and nanostructured materials can be categorized into four types: organic nanomaterials (e.g., micelles, dendrimers, polymersomes, hydrogels, nanoconjugates), inorganic nanomaterials (e.g., metals, metal oxide, and ceramic nanomaterials), carbon-based nanomaterials (fullerenes, carbon nanofibers, diamonds carbon nanotubes, and graphene), and composite nanostructures [1,22]. The synthesis of traditional nanosized products contributes to the present and future economic growth of many countries. Based on porosity, nanomaterials can be classified into porous and non-porous materials [3]. Porous materials have a less dense molecular structure to allow airflow or the absorption of atoms, ions, and molecules. Non-porous materials are denser, do not absorb well, and allow limited airflow. Mesoporous (or super-nanoporous) nanomaterials are nanoporous materials with pores of $2 { - } 5 0 \mathrm { n m }$ in diameter [23,24]. Recent research has focused on mesoporous nanomaterials for delivering therapeutic agents to tumor cells with little drug leakage into healthy cells. The high porosity, surface functionality, and small pore size of mesoporous nanoparticles allow the controlled release and efficient drug loading at the target site [22].

Considering the growing use of nanomaterials over the last decades, our group reviewed the key aspects of different types of nanomaterial design and their emerging applications in the biomedical fields [1–3,15]. This review article discusses the uniquerticular emphasis on the preparation methods used for designing nanomaterials features of nanomaterials that are exploited for different biomedical applications (Figure 1).dvancement of nanomaterials in the biomedical and health sectors (bioimaging, t It also presents recent trends on nanomaterials use for biomedical engineering, with agineering, wound dressings, drug delivery, biosensors, food industry, and agricu particular emphasis on the preparation methods used for designing nanomaterials. The discussed. The review deals with various relevant nanomaterials variables, su advancement of nanomaterials in the biomedical and health sectors (bioimaging, tissuearge, concentration, particle surface modification, and size, which must be consi engineering, wound dressings, drug delivery, biosensors, food industry, and agriculture)uring the bioimaging of living cells. Various targeted drug delivery systems for tre is discussed. The review deals with various relevant nanomaterials variables, such as charge, concentration, particle surface modification, and size, which must be considered during the bioimaging of living cells. Various targeted drug delivery systems for treating chronic diseases are described. The use of nanomaterials to improve dental implants is alsoady described the biomedical applications of nanomaterials [1–4], this review w discussed, as well as the fabrication methods [14]. As many review articles have alreadytended to discuss the nanomaterial’s toxicity, risks, and regulations in the biome described the biomedical applications of nanomaterials [1–4], this review will be extendedctor. to discuss the nanomaterial’s toxicity, risks, and regulations in the biomedical sector.

![](images/a2e451c9abbe8c623ccae8ca35b8cdaffb8a29771b784b1ad6f3c515cb4d446b.jpg)  
gure 1. Summary of the recent topic on nanoparticles and nanostructured materials and theFigure 1. Summary of the recent topic on nanoparticles and nanostructured materials and their ications in bioimaging, biosensing, drug delivery, tissue engineering, antimicrobial, and applications in bioimaging, biosensing, drug delivery, tissue engineering, antimicrobial, and agrood sectors. Image created by Biorenderfood sectors. Image created by Biorender.

# 2. Fluorescent Nanomaterials for Bioimaging

Bioimaging is an advanced non-invasive technology used to visualize internal strucBioimaging is an advanced non-invasive technology used to visualize internal tures and physiological processes in living cells/organisms in real-time. It is a safe and res and physiological processes in living cells/organisms in real-time. It is a safeffective technique for monitoring biological functions without affecting normal life profective technique for monitoring biological functions without affecting normal lifecesses (e.g., respiration and movement). It also helps to obtain data on the sample 3D sses (e.g., respiration and movement). It also helps to obtain data on the sampnanostructure [25] and to investigate tissues at the subcellular and multicellular scale [26]. nostructure [25] and to investigate tissues at the subcellular and multicellular scaleSeveral nanoprobes have been developed for bioimaging and the treatment of many disveral nanoprobes have been developed for bioimaging and the treatment of maneases (cancer, heart, and inflammatory diseases) [27–29]. Nanomaterials are ideal materials for nanoprobes because they can be exactly characterized using nuclear magnetic resonance or gel permeation chromatography and are easily secreted from the body. However, their functions are limited, and researchers are always looking for new materials. In recent days, magnetic nanoparticles have gained great interest because of their progress in image-le properties, such as tunable size, generating reactive oxygen species guided therapy (e.g., fluorescence, magnetic resonance, X-ray CT) and cancer theranosis favorable properties, such as tunable size, generating reactive oxygen species (ROS) or heat, simple fabrication, energy transfer, and X-ray absorption properties (Figure 2). Moreover, their long-term toxicity and dispersion stability must be specifically investigated.

![](images/6f117d8c6d42e8742a93194f4b987ea0f4027b6d1e528dbaf8f0f59996039a0f.jpg)  
representation showing the utilization of magnetic nanoparticles in tumor bi-Figure 2. Schematic representation showing the utilization of magnetic nanoparticles in tumor py [30]. Copyright 2016, American Chemical Society. bioimaging and therapy [30]. Copyright 2016, American Chemical Society.

particles’ specificity, light-emission (NIR-IR emission), and biocom-Fluorescent nanoparticles’ specificity, light-emission (NIR-IR emission), and biocompatibility with the target tissues can be customized by changing their shape, size, and surface properties [27]. The cell uptake of nanoparticles used for bioimaging is influenced 7]. The cell uptake of nanoparticles used for bioimaging is influenced mainly by the following factors [31,32]: (i) size, smaller nanoparticles with identical surface owing factors [31,32]: (i) size, smaller nanoparticles with identical sur-properties are better absorbed than bigger nanoparticles [33]; (ii) charge, positively charged e better absorbed than bigger nanoparticles [33]; (ii) charge, positively nanoparticles are preferentially taken up by living cells due to the cell membrane negative icles are preferentially taken up by living cells due to the cell membrane charge [34,35]; (iii) cell-specific targeting, this is achieved by conjugating nanoparticles with ligands that can interact with receptors at the cell surface [36,37]; (iv) the conjugation of proteins on the nanoparticles’ surface may promote rapid absorption and endosome bypass [38]; (v) oligodeoxynucleotide conjugation can help in the presence of completeins on the nanoparticles’ surface may promote rapid absorption and mentary cellular DNA at a specific subcellular location [39,40]; (vi) endosome egress of [38]; (v) oligodeoxynucleotide conjugation can help in thnanoparticles that are positively charged at the surface in the low $\mathrm { p H }$ resence of  environment of late ellular DNA at a specific subcellular location [39,40]; (vi) endosome endosomes. It was reported that small nanoparticles can bypass the degradation pathways ticles that are positively charged at the surface in the low pH environ-more efficiently than larger size particles with the same chemical composition [41].

The fluorescent nanoparticles used in bioimaging can be classified into two categories: (1) fluorescent nanoparticles that can emit specific optical signals, such as carbon and re efficiently than larger size particles with the same chemical composi-metallic quantum dots, (2) fluorescent nanoparticles that require labeling with a fluorophore to be visualized, such as fluorescence mesoporous $\mathrm { S i O } _ { 2 }$ and ${ \mathrm { F e } } _ { 2 } { \mathrm { O } } _ { 3 }$ NPs, liposomes, proteinnt nanoparticles used in bioimaging can be classified into two catego-based, and polymeric nanoparticles. Many classical fluorophores emit fluorescence at a t nanoparticles that can emit specific optical signals, such as carbon and short wavelength (e.g., the ultraviolet (UV) and visible regions) that can be easily absorbed dots, (2) fluorescent nanoparticles that require labeling with a fluoro-and scattered by human tissues. This can lead to specific issues, for instance, elevated autofluorescence, low signal-to-background ratio, and limited tissue penetration. High-energy light could be used to overcome these drawbacks, but it can cause phototoxicity in human d polymeric nanoparticles. Many classical fluorophores emit fluores-tissues. Optical imaging in the near-infrared (NIR) region is a possible alternative (Figure 3). avelength (e.g., the ultraviolet (UV) and visible rFluorophores in the first near-infrared window (NIR-I, $7 0 0 { - } 9 0 0 \mathrm { n m }$ t can be eas-) have been tested and cattered by human tissues. This can lead to specific issues, for instance, show good sensitivity; however, their application in bioimaging is limited due to their poor tissue penetration (less tolimited due to their poor tis $1 \mathrm { c m }$ ) and large photon scattering losses in biological matter.penetration (less to 1 cm) and large photon scatter Therefore, fluorescent quantum dots losses in biological matter. Therefore $\leq 1 0 \ \mathrm { n m } )$ that allow fluorescent bioimaging in theent quantum dots (≤10 nm) that allow fl NIR-II windowrescent bioimag $( 1 0 0 0 { - } 1 7 0 0 \mathrm { n m }$ ) have been developed [42].-II window (1000–1700 nm

![](images/8237d440018f7bf03f45677e11d713fd13f3c93225bef9064c84feb18a145c3b.jpg)  
Figure 3. Schematic presentation showing fluorescence imaging approaches of traditional methFigure 3. Schematic presentation showing fluorescence imaging approaches of traditional methods versus rare-earth-metal doped nanoparticles. (A) The spectral range of classical fluorescence imversus rare-earth-metal doped nanoparticles. (A) The spectral range of classical fluorescence imaging ing methods. NIR, near-infrared region. (B) Examples of probes in the NIR-II region: single-wamethods. NIR, near-infrared region. (B) Examples of probes in the NIR-II region: single-walled carbon nanotubes (SWNTs), rare-earth-metal doped nanoparticles (RENPs), organic dyes, cocarbon nanotubes (SWNTs), rare-earth-metal doped nanoparticles (RENPs), organic dyes, conjugated gated polymers, and quantum dots (QDs). (C) Nanoparticles are doped with rare-earth metals (polymers, and quantum dots (QDs). (C) Nanoparticles are doped with rare-earth metals (Nd, Tm, Pr, Tm, Pr, Ho, Er) [42]. Copyright 2020, Ho, Er) [42]. Copyright 2020, Frontiers.

Fluorescent metal quantum dots (e.g., Au, ZnSe, InAs, CdTe, InP, or CdS) with a Fluorescent metal quantum dots (e.g., Au, ZnSe, InAs, CdTe, InP, or CdS) with a size in thein the $1 { - } 1 0 \mathrm { n m }$ range show broad absorbance bands and narrow emission bands and  range show broad absorbance bands and narrow emission bands and are interesting for bioimaging in the NIR range [43]. These inorganic nanoparticles are interesting for bioimaging in the NIR range [43]. These inorganic nanoparticles are the most most frequently used in bioimaging because of their intense color, shape, size, and hifrequently used in bioimaging because of their intense color, shape, size, and high-power surface photoluminescence. They allow the non-invasive detection of disease and the monitoring of its progression/response to treatments in humans and animals [44]. Metal oxide $( \mathrm { F e } _ { 3 } \mathrm { O } _ { 4 } , \mathrm { W O } _ { 3 } , \mathrm { W O } _ { 2 . 9 } )$ [30,32], lanthanide-doped nanoparticles [45], and quantum dots (QDs) [30] have also been tested for bioimaging and therapy. The nanoparticles optical and physical features can be tailored by structure amplification, which is their most distinctive advantage for optical imaging. Ceramic nanomaterials (mesoporous $\mathrm { T i O } _ { 2 }$ distiand $\mathrm { S i O } _ { 2 }$ e advantage for optical imaging. Ceramic nanomaterials (mesoporous TiO2 NPs) also are among the most interesting candidates for bioimaging because of SiO2 NPs) also are among the most interesting candidates for bioimaging because of ttheir size-manageable morphology, easy functionalization, and biocompatible hydrophilic size-manageable morphology, easy functionalization, and biocompatible hydrophilic ssurface [46,47]. FDA-approved silica is less toxic and is biocompatible [48]. Magnetic metal face [46,47]. FDA-approved silica is less toxic and is biocompatible [48]. Magnetic moxide nanoparticles can be exploited as nanocarriers for substances that are optically active oxide nanoparticles can be exploited as nanocarriers for substances that are optically or that can emit optical signals upon excitation, depending on their structural composition. tive or that can emit optical signals upon excitation, depending on their structural cHowever, using magnetic metal oxide nanoparticles in bioimaging is challenging due position. However, using magnetic metal oxide nanoparticles in bioimaging is challeto their loading capability, synthesis complexity, regulatory hurdles, imaging efficiency, ing due to their loading capability, synthesis complexity, regulatory hurdles, imagingtoxicity of the intrinsic ingredients, batch reproducibility, production cost, in vivo stability, ficiency, toxicity of and storage [49,50].

Fluorescent carbon nanoparticles are also interesting for bioimaging applications [51] for several reasons, particularly source abundance, simple synthesis, low cost, and nontoxicity [52]. Fluorescent carbon nanoparticles, such as fullerenes and carbon quantum dots, are considered to be promising nanomaterials alternatives to fluorescent semiconductor quantum dots, which are composed of toxic heavy metals, such as cadmium [53,54]. dots, are considered to be promising nanomaterials alternatives to fluorescent semicFullerenes and carbon quantum dots are strong candidates for bioimaging applications [55].

Indeed, they are superior to the currently used inorganic quantum dots and traditional organic fluorophores in terms of photo-bleaching resistance, easy surface functionalization, and chemical inertness [56]. Their greater aqueous solubility, minimum cytotoxicity, and substantial fluorescence quantum yields explain their suitability for biomedical applications, specifically for in-vitro and in-vivo bioimaging [57,58].

Rare-earth metals are primarily used to develop nanoparticles with persistent luminescence [58]. However, the major issue linked to the use of rare-earth metal-based nanoparticles in vivo is their potential cytotoxicity and their low tunability for surface modification [59,60]. Therefore, non-toxic conjugated polymer nanoparticles with tremendous optical properties have been developed to act as persistent luminescence materials that can replace the conventional rare-earth metal-based nanoparticles. Conjugated polymer nanoparticles display excellent photoelectronic properties due to the highly localized $\pi$ electrons on their backbones [61]. Additionally, due to their light-harvesting and light-amplifying properties, conjugated polymers act as biological photoactive materials. Water-soluble conjugated polymers have been developed and used in drug/gene delivery, biosensing, bioimaging, and antitumor/antimicrobial therapeutics [62,63]. Moreover, it has been demonstrated that conjugated polymers do not have any cytotoxic effect on the host cells and have structure-dependent tunable optical properties [64,65]. Currently, conjugated polymer nanoparticles can be prepared using four different approaches: solvent exchange (nanoprecipitation), mini-emulsion, self-assembly, and emulsion polymerization.

Du et al. [66] described a fast and multimodal approach for in vivo fluorescence bioimaging through the synthesis of Fe and $Z \mathbf { n }$ nanoclusters in HepG2, HeLa, and U87 cancer cells. They showed that fluorescent magnetic $\mathrm { F e } _ { 3 } \mathrm { O } _ { 4 }$ nanoclusters and $Z _ { \mathrm { { n O } } }$ nanoclusters are synthesized by cancer cells in which $Z \mathrm { n } ^ { \bar { 2 } + }$ and $\mathrm { F e } ^ { 2 + }$ (which are biocompatible) have been introduced. These nanoclusters are promising candidates for multiplexed imaging that integrates fluorescence imaging, computed tomography, and magnetic resonance imaging. Moreover, they did not observe any significant variation in the fluorescence signal before and after the injection of $Z \mathrm { n } ^ { 2 + }$ and $\mathrm { F e } ^ { 2 + }$ in normal human liver cells (L02) and tissues. This suggests that this multiplexed bioimaging system could be interesting for monitoring the response to cancer treatment and also for cancer diagnosis. Wang et al. manufactured multicolored conjugated polymer nanoparticles for targeted tumor imaging (Figure 4) [67,68]. Functionalized conjugated polymer nanoparticles with carboxyl groups were fabricated by coprecipitation of poly (styrene co-maleic anhydride) (PSMA) with four conjugated polymers (P1, P2, P3, and P4) with blue, green, yellow, and red fluorescence emission, respectively [67]. Energy could be transferred from nanoparticles with shorter wavelength emission to nanoparticles with longer wavelength emission, leading to the formation of multi-colored nanoparticles with whole visible light absorption and emission spectrum via only one excitation. For enhancing their specificity towards tumor cells, conjugated polymers (P1-4/PSMA) were labeled with an antibody against EpCAM (a protein overexpressed in many cancer types). Excitation was recorded in antibody-labeled conjugated polymers (P1-4/PSMA/anti-EpCAM) at different wavelengths. Then, due to the antibody cross-reactivity, Wang et al. used P3/PSMA/anti-EpCAM and P3/PSMA/anti-ErbB2 to differentiate between HeLa and MCF-7 cells (EpCAM), and SK-BR-3 cells (ErbB2), although MCF-7 and SK-BR-3 cells were derived from the same patient [67,69].

![](images/4a3ad1c7193174a6db54c4a7fb758dc2b676d5eedd671d53f2a03188f20c758b.jpg)  
r conjugated polymer with carboxyl groups were fabricated from poly (styrene Figure 4. Multicolor conjugated polymer with carboxyl groups were fabricated from poly (styrene e) (PSMA) with four conjugated polymers (P1, P2, P3, and P4), for cancer cell co-maleic anhydride) (PSMA) with four conjugated polymers (P1, P2, P3, and P4), for cancer cell etection. (a) UV-vis absorption, and (b) fluorescence emission spectra of P1–bioimaging and detection. (a) UV-vis absorption, and (b) fluorescence emission spectra of P1–4/PSMA cles in water (excitation wavelength: 360 nnanoparticles in water (excitation wavelength: $3 6 0 \mathrm { n m }$ conjugated polymer nanopar-). The conjugated polymer nanoparticles ed by precipitation of the tetrahydrofuran solution (2.0 µgwere fabricated by precipitation of the tetrahydrofuran solution $( 2 . 0 ~ \mu \mathrm { g } / \mathrm { m L }$ , 7.0 µ of P1, $7 . 0 ~ \mu \mathrm { g } / \mathrm { m L }$ of f P3P2, $4 . 0 ~ \mu \mathrm { g / m L }$ mL ofof P3, $1 2 . 0 ~ \mu \mathrm { g / m L }$ .0  of $\mathrm { P 4 }$ /mL, and $2 0 . 0 ~ \mu \mathrm { g / m L }$ into water. (c) Multi-channel  of PSMA) into water. (c) Multi-channel s of MCF-7 cells using P1–4/PSMA/anti-EpCAM polymer nanoparticles. The ex-fluorescence images of MCF-7 cells using P1–4/PSMA/anti-EpCAM polymer nanoparticles. The hs are indicated above the panels [67]. Copyright 2014, Wiley. excitation wavelengths are indicated above the panels [67]. Copyright 2014, Wiley.

biological causes and developing therapeutic strategies requires the Understanding biological causes and developing therapeutic strategies requires the ability to track cell migration and circulation in vivo. Many attempts have been undertaken to investigate novel and improved cell labeling and imaging techniques, and much ate novel and improved cell labeling and imaging techniques, and much has already been learned from these approaches. The capacity to visualize these cells learned from these approaches. The capacity to visualize these cells pre-precisely could help in the diagnosis and prognosis of disorders, such as atherosclerosis, neurodegenerative diseases, cancer, and myocardial infarction. Understanding the behavior of circulating cell populations, such as monocytes, macrophages, and circulating tumor cells (CTCs) spread from solid tumors, could provide crucial information on features that could aid in the development of better treatments [70]. Chen’s team observed CTC behavior in blood arteries surrounding solid tumors using a multiphoton device with a $3 0 ~ \mathrm { H z }$ collection rate. The highest number of circulating tumor cells each minute was estimated to be around 100, which could be linked to cancer progression [71]. Furthermore, by labeling circulating tumor cells with antibody-conjugated quantum dots, the behavior of uncommon subpopulations of circulating tumor cells with higher metastatic potential, such as $\mathrm { C D 2 4 + }$ and CD $^ { 1 3 3 + }$ CTCs, has been observed. Jia’s team produced doxorubicin (DOX)-loaded MSNs that are decorated with anti-EpCAM and anti-CD44 aptamers to deliver cancer metastasis chemopreventive medications selectively toward circulating tumor cells. DOX-fluorescence MSNs enable the self-tracking of targeting efficacy and drug administration into colorectal cancer cells. It was possible to track not only how the transplanted CD45-CD541CD1571 lung stem/progenitor cells were precisely located in vivo but also how these cells incorporated and reformed themselves over time at a single-cell resolution using a combination of fluorescent nanodiamonds, fluorescence-activated cell sorting, and fluorescence lifetime imaging microscopy. HNF3 plasmid DNA (pDNA) was efficiently transported by fluorescein isothiocyanate (FITC)-tagged MSNs as a differentiating agent for iPSCs. The indoctrination procedure was simultaneously observed due to their self-monitoring capacity [72].

Surface functionalization of nanoparticles is a crucial issue for their use in bioimaging applications (Table 1) [68,69]. However, the selection of the most suitable nanoparticles for a specific bioimaging application (e.g., computed tomography) is difficult, and several aspects (biological safety, sensor capacity, size, brightness, and photostability) must be taken into account. After finding the best material for a specific application, all experimental methods must be adapted and adjusted to the selected material. This is not an easy task. A deeper knowledge of the impact of nanoparticles on living cells will help to understand the imaging potential of those nanoparticles and how it is adsorbed by cells. Therefore, more research efforts are needed to promote nanoparticle exploitation in bioimaging applications.

Table 1. Different nanomaterial types are used for bioimaging applications.   

<html><body><table><tr><td>Nanomaterial</td><td>Functionalization</td><td>Cell Lines</td><td>Refs</td></tr><tr><td>Graphene-based nanosheets</td><td>Surface functionalization by bio-compatible targeting ligands and coatings</td><td>MDA-MB-468 (MCF-7)</td><td>[70]</td></tr><tr><td> Molybdenum disulfide</td><td>Chitnan: PLGA, PFEG</td><td>Bretccels cancer cells</td><td>[71]</td></tr><tr><td>Trasion etil npoyartisles</td><td>Polymer functionalization</td><td>Mice bearing4T1brestcacer</td><td>[72]</td></tr><tr><td>Lanthanideractivated</td><td>Doping with lanthanide</td><td>Cancer cells xenografted in mice</td><td>[73]</td></tr><tr><td>Group IV quantum dots</td><td>Surface functionalization</td><td>Various cancer cell types</td><td>[74]</td></tr><tr><td>Graphene oxide nanosheets</td><td> Surface functionalization</td><td>Tumor cells</td><td>[75]</td></tr><tr><td>Peptide-based nanoparticles</td><td>Chemical functionalization</td><td>Petidetretelsde</td><td>[76]</td></tr><tr><td>Silver nanoparticles</td><td>Aptamer conjugation</td><td>eke</td><td>[77]</td></tr></table></body></html>

Table 1. Cont.   

<html><body><table><tr><td>Nanomaterial</td><td>Functionalization</td><td>Cell Lines</td><td>Refs</td></tr><tr><td>Gold nanoprisms</td><td>Conjugation with polyethylene glycol</td><td>Gastrointestinal carcinoma cells (HT 29)</td><td>[78]</td></tr><tr><td>Gold nanorods</td><td> Encasing by mesoporous silica</td><td>Carcinoma cells</td><td>[79]</td></tr><tr><td>Magnetofluroscentnanoprobe</td><td>Surface functionalization</td><td>Human Breast Cancer(MCF-7),</td><td>[80]</td></tr><tr><td>Dye-loaded nanoemulsions</td><td>Lipidyehyle in with</td><td>Human coloncancer H11),)</td><td>[81]</td></tr><tr><td> Cadmium telluride quantum dots</td><td>Capping by shells</td><td>Human bronchial epithelial cells</td><td>[82]</td></tr></table></body></html>

# 3. Nano-Drug Delivery Systems

Drug delivery systems are quite new, but is a rapidly expanding technology. In these systems, nanoscale materials are used to deliver the therapeutically active drug or the imaging molecule (when used as diagnostic tools) to the targets [83]. Nanostructures (made of metals, organic/inorganic, and polymeric materials) are often used for the development of drug delivery systems (Figure 5). Nanoparticles and nanostructured materials are crucial components in these carrier systems that play a key role in personalized medicine by improving drug formulation/targeting/controlled release [83,84]. Such systems can deliver a drug to a specific site at a predetermined rate and in a predesigned manner; consequently, the drug bioavailability will be enhanced, while side effects will be reduced. Drugs can be physically or chemically adsorbed into the nanoparticles surface through various adsorption methods, or they can be loaded on nanoparticles during their production [83,85]. The drug and carrier properties, such as drug-carrier solubility, molecular weight, drug-carrier chemical interaction, and carrier size, will determine the drug loading efficacy on/into the carrier [83,86]. The drug release rate from the nanoparticlesis mainly influenced by (1) the release of the adsorbed drug from the surface of the nanoparticles; (2) the drug diffusion from thenanoparticles; and (3) the nanoparticle erosion and drug diffusion from the nanoparticles. Therefore, the drug release rate from the nanoparticles will be governed by polymer biodegradation and drug diffusion. The drug release time and location can be modulated by the nanoparticles composition (e.g., thermosensitive and pH-sensitive materials) and engineering (e.g., monolayer and multilayer nanoparticles, nanocapsules), and also by better understanding the physiological factors involved in this process [83,87] (Figure 5).

Many researchers worldwide are investigating whether and how nanoparticles (e.g., metals, metal oxides, carbon, quantum dots, liposomes, dendrimers) can be used as carriers for different therapeutic agents [88,89]. Graphene oxide nanosheets, graphene quantum dots, single/multiwalled carbon nanotubes, and graphene oxide nanosheets are carbon-based nanomaterials with different drug-loading capacities, targeting specificity, and drug release kinetics. This partly explains the discrepancies in the therapeutic efficiency of these different nanomaterials when used as drug-carrier systems. Biodegradable polymer nanoparticles are used in new drug delivery systems because of their flexibility and many interesting characteristics, such as controlled release, stability in blood, non-immunogenic, and non-toxic nature [85]. Micelles, liposomes, emulsions, and nanoparticles are colloidal drug carriers that are used to increase the number of drugs that can pass through the blood–brain barrier. Similarly, colloidal systems are used to regulate the drug release rate at target locations (cells or tissues).

![](images/866a77b0e2f7d5c2534b8f83fe89ff8787fc620d12b88bbe97c77bf2c16110bd.jpg)  
Figure 5. Characteristics of nanomaterials that can cross the biological membranes to deliver a drug to a specific site and mechanisms influencing controlled drug release. Image created by Biorender.

nisms influencing controlled drug release. Image created by Biorender. Drug delivery via nanocarrier systems presents some strengths compared with conventional drug administration methods, particularly very high accuracy, targeting ability, stability, and sustainability at the target location [83,90]. Delivery systems made of large-size rs worldwide are investigating whether and how nanoparticles (e.g., materials display major drawbacks, such as poor absorption, in vivo stability, bioavailabilcarbon, quantum dots, liposomes, dendrimers) can be used as carri-ity, and solubility, which may decrease their efficacy and target specificity. The major goal of using nanoparticles as drug carriers is to reduce the drug toxicity and increase its bioavailability, target specificity, and delivery without any loss of the therapeutic effects [83,91]. tiwalled carbon nanotubes, and graphene oxide nanosheets are car-The key challenges when looking for suitable carriers are: (1) drug release kinetics and rials with different drug-loading capacities, targeting specificity, and integration, (2) shelf life and stability of the formulation, (3) biocompatibility of the formulation, (4) biodistribution and targeting, and (5) possible nanocarrier accumulation in the body in the case of prolonged treatment using drug-loaded nanocarriers. Currently, the available data do not allow the determination of the toxicological and environmental impacts of drug-loaded nanocarriers [83,92]. Furthermore, drugs can also be synthesized at the nanoscale, and then they can act as their own “carrier” for delivery. Table 2 lists different nanocarriers used for the delivery of therapeutic molecules/drugs.

Table 2. Nanomaterials used for drug delivery.   

<html><body><table><tr><td>Nanocarrier</td><td>Loaded Drug</td><td>Therapeutic Action</td><td>Ref</td></tr><tr><td colspan="4">Metal-based nanoparticles</td></tr><tr><td>Gold nanoparticles</td><td>Doxorubicin Theophylline (THP),</td><td>Anticancer effect in HeLa cells</td><td>[93]</td></tr><tr><td> Gold nanoparticles</td><td>1,3-dipropyl-8- cyclopentylxanthine (DPCPX)</td><td>Neuron reconstruction in vivo</td><td>[94]</td></tr><tr><td>Silver nanoparticles</td><td>Methotrexate-coated PEG</td><td>Anticancer effect in MCF-7 cells</td><td>[95]</td></tr><tr><td colspan="4">Metal oxide-based nanoparticles</td></tr><tr><td>Fe3O4 nanoparticles</td><td>Doxorubicin</td><td>Anticancer effect in HeGP2 and Lo2 cells.</td><td>[96]</td></tr><tr><td>Fe3O4 nanoparticles</td><td>Fluorouracil</td><td>Anticancer effect in MCF-7 cells</td><td>[97]</td></tr><tr><td colspan="4">Carbon-based nanoparticles</td></tr><tr><td> Multilayer carbon nanotubes</td><td>Dexamethasone</td><td>Anti-inflammatory effect in Highly-Aggressively Proliferating</td><td>[98]</td></tr><tr><td> Single-layer carbon nanotubes</td><td>Cisplatin</td><td>Immortalized cells (HAPI) Antifd</td><td>[99]</td></tr><tr><td colspan="4">Quantum dots</td></tr><tr><td>Ag-In-Zn-S quantum dots modified Lwith with folic acid</td><td>Doxorubicin</td><td>At</td><td>[100]</td></tr><tr><td colspan="4">Nano-clays</td></tr><tr><td>Laponite nanoplates</td><td> Anionic dexamethasone</td><td>Antifi</td><td>[101]</td></tr><tr><td colspan="4">Dendrimers</td></tr><tr><td>Poly-amido-amine dendrimers</td><td>Methotrexate</td><td>Anticancer effect in methotrexate ympo</td><td>[102]</td></tr><tr><td>Polymeric nanoparticles</td><td></td><td>Chinese hamster ovary (CHO) cells</td><td></td></tr><tr><td colspan="4"></td></tr><tr><td>Poly-lactic acid</td><td>Paclitaxel</td><td>Anticceefeean</td><td>[103]</td></tr><tr><td>Chitosan</td><td>Tacrine</td><td>e</td><td>[104]</td></tr><tr><td colspan="4">Liposomes</td></tr><tr><td>Liposomes</td><td>Dexamethasone phosphate</td><td>Ati</td><td>[105]</td></tr><tr><td>Liposomes</td><td>Cetuximab and oxaliplatin</td><td>Antie</td><td>[106]</td></tr><tr><td colspan="4">Nanofibers</td></tr><tr><td>Polyvinyl alcohol</td><td></td><td>Anticacefdith</td><td>[107]</td></tr><tr><td>Polylactic acid electrospun nanofibers</td><td>Doxorubicin</td><td>Ati</td><td>[108]</td></tr></table></body></html>

# 3.1. Nano-Vehicles for Anticancer Drugs

After heart disease, cancer is the second most common cause of death worldwide [109,110]. Functionalized nanocarriers can be used to develop targeted anticancer treatments. Compared with systemic chemotherapy, in these systems, nanoparticles loaded with therapeutics and targeting molecules are specifically delivered to the tumor cells and show good efficacy at lower doses and, consequently, with fewer undesirable effects [111]. Several studies suggest that nanocarriers are interesting tools to improve cancer diagnosis (as imaging agents) and treatment [112,113]. Over the last two decades, nanoparticles products have been evaluated in several clinical trials [114].

The efficacy of chemotherapeutic agents at the target site can be increased by encapsulating them in nanoparticles that target the tumor cells actively or passively. Nanoparticles offer various advantages when used for drug delivery: (i) overcoming the stability and solubility issues of chemotherapeutic drugs; (ii) protecting the drug from modifications by enzymes (e.g., proteases and other metabolic enzymes) and, thus, also increasing the drug half-life in blood; (iii) increasing drug targeting and distribution; (iv) modulating the drug release kinetics; and (v) reducing resistance to treatment by delivering multiple drugs [84].

Often, after reaching the target, the anticancer drug efficacy is significantly reduced for many different reasons (e.g., too low concentration) [84]. As the therapeutic effect of a drug is possible only if present at the right concentration and in the correct form, nanoparticles used as carriers could increase the local drug concentration inside and around tumor cells. This also decreases the risk of toxicity for healthy cells. The drug-carrying nanoparticles deliver the drug directly into its targeted body area (organ, cellular, and subcellular level of specific tissue) to overcome the specific toxic effect of conventional drug delivery, thereby reducing the amount of drug required for therapeutic efficacy. As a result, the use of nanoparticles in drug delivery opens new possibilities for improving drug distribution and changing cancer management [115]. The interaction of nanoparticles with ligands (nucleic acid aptamers, peptides, antibodies, carbon dioxide, and tiny molecules) may contribute to the active targeting of cancer cells and organs.

Polymeric nanoparticles can be used for the controlled release of the encapsulated drugs by surface erosion, diffusion, and swelling, followed by diffusion, depending on the time and condition. The most widely used biocompatible polymers for controlling drug release are poly(D, L-lactide), poly(glycolide), and its co-polymer poly(lactic-co-glycolic acid) [116]. Biodegradable polymer nanoparticles for cancer treatment have been extensively studied [117,118]. Liposomes were the first nanoparticles to be used to administer chemotherapy. Cohen and Bangham were the first to describe liposomes 40 years ago [119]. Liposomes are structured like vesicles with an aqueous interior and one or more concentrically phospholipid bilayers with diameters ranging from $3 0 \mathrm { n m }$ to several microns. They are produced using different methods and display different sizes, lipid compositions, and surface chemistry. Liposomes can be used as flexible carriers that can be tailored to various functions and have a specific drug delivery role [120]. Several materials, such as biodegradable polymers, dendrimers, and nucleic acid-based nanoparticles, have also been used to develop targeted cancer treatments [121,122].

Electrospun nanofibers have also been evaluated for localized anticancer drug delivery [113,114]. They can efficiently deliver the desired drug to the target cancer cells compared with conventional diffusion-based drug delivery vehicles [122–125]. Zhang et al. manufactured a nanofiber-based localized anticancer drug delivery system by electrospinning a solution containing self-assembled $\mathrm { P E G } _ { 2 0 0 0 }  – \mathrm { P t } ( \mathrm { I V } )$ micelles with dichloroacetate (DCA) that “acts as a prodrug” and with polyvinyl alcohol. This delivery system allowed the quick release of $\mathrm { P E G } _ { 2 0 0 0 }  – \mathrm { P t } ( \mathrm { I V } )$ -based micelles and DCA that showed a synergistic apoptotic effect on cancer cells through two apoptotic mechanisms [107]. Table 3 lists various nanomaterial types exploited in delivery systems for anticancer agents.

Table 3. Different examples for nanomaterials being used in anticancer drug delivery systems.   

<html><body><table><tr><td>Nanomaterial</td><td> Anticancer Drug</td><td>Targeted Cancer Cells</td><td>Refs</td></tr><tr><td>Silver nanoparticles</td><td>Terminaliachebula</td><td>Breast cancer cells (MCF-7)</td><td>[126]</td></tr><tr><td>Glycerylmonooleate nanostructures</td><td>Doxorubicin hydrochloride</td><td>Breast cancer cels (MCF-7, MDA-MB-231)</td><td>[127]</td></tr><tr><td>biodPoly (HB-copartiles</td><td>Docetaxel</td><td>Breast and prostate cancer cells</td><td>[128]</td></tr><tr><td>Carbon nanodots</td><td>Irinotecan</td><td>Breast cancer cells (MCF-7, MDA-MB-231)</td><td>[129]</td></tr><tr><td> Polysaccharide nanoparticles</td><td>Lapatinib</td><td>Breast cancer cels (MCF-7/ADR)</td><td>[130]</td></tr><tr><td>Fe3O4 nanoparticles</td><td>Doxorubicin</td><td>HepGP2 liver cancer cells and LO2 liver cells</td><td>[96]</td></tr><tr><td>Fe3O4 nanoparticles</td><td>Fluorouracil</td><td>Tumor cells and in vitro analysis</td><td>[97]</td></tr><tr><td> Porous silicon nanoparticles</td><td>Doxorubicin and siRNA</td><td>Prostate cancer cells</td><td>[131]</td></tr><tr><td>Thermdwitiveli ioromnes</td><td>Doxorubicin</td><td>EGFR-expressing breast cancer cells</td><td>[132]</td></tr><tr><td>Iron oxide nanoparticles</td><td>Cetuximab</td><td>A431 (epidermoid carcinoma) cell lines</td><td>[133]</td></tr></table></body></html>

# 3.2. Nanostructured Materials as Drug Delivery Vehicles for Antioxidant Drugs

Antioxidants are reactive molecules that are produced by the body in response to environmental stress and other stimuli and that contribute to limiting cell damage by free radicals. Therefore, they are also called “free-radical scavengers”. Antioxidants are present in many food types and can also be synthesized. However, due to their limited cellular absorption, potency, and lack of precise transportation systems to a specific organ, cell, and tissue, their use for treating diseases in which oxidative stress plays a major role is still limited, particularly for neurodegenerative diseases where the brain targeting is still challenging [83]. Nanotechnology can address these drawbacks, especially the targeting of dietary antioxidants with neuroprotective properties. Indeed, antioxidant molecules can be protected from degradation using nanotechnology-based delivery mechanisms that improve their bioavailability and physicochemical drug-like properties [134].

However, most nanoparticle-based formulations tend to cause oxidative stress in the cells, and this hampers their routine clinical use. Importantly, the amount of reactive oxygen species (ROS) produced by the cells is proportional to the concentration of nanoparticles to which the cells were exposed [135]. Moreover, the cellular redox balance is influenced by nanomaterials, and this can lead to the inhibition or induction of ROS production [83]. Excess reactive oxygen species production and endogenous antioxidant system overload are common side effects of high nanoparticle concentrations, resulting in cytotoxicity and inflammation [83,136]. As a result, determining the maximum permissible doses is important to minimize negative effects. However, several studies suggest that low nanoparticle exposure levels can unintentionally boost the antioxidant defenses and reduce oxidative stress. Moreover, some nanomaterials have enzyme-like antioxidant properties, and they reduce oxidative damage and scavenge reactive oxygen species and free radicals [137].

Nanoparticles’ antioxidant properties depend on their surface load, volume surface ratio, chemical composition, particle size, and surface coating [138]. Nanoparticles offer many advantages compared with traditional methods of antioxidant supplementation, including the environmental safety of bioactive materials, improved bioavailability and selective antioxidant supplementation, and controlled release at the target site [139,140]. The antioxidant function of transition metal oxide nanoparticles $\mathrm { { \ C u O , } }$ NiO NPs) has been widely studied and exploited [141–144]. Cerium oxide nanoparticles $( \mathrm { C e O } _ { 2 }$ NPs) are particularly interesting because of their reactive oxygen species (ROS) scavenging and regenerative effects [145]. These nanoparticles display special features: the coexistence in both oxidation states $\mathrm { \langle { e } ^ { 3 + } }$ and $\mathrm { C e ^ { 4 + } }$ ), reversible switching between these states, and reduction potential of 1.52 V [146]. Gold nanoparticles (Au NPs) have been extensively evaluated by the pharmacology and biomedical sectors due to their inert and non-toxic nature [147]. Silver nanoparticless loaded on the $( \mathrm { A g N P s } )$ also have a strong antioxidant capacity (reduction power andorous SiO2 nanoparticle surface. Morin flavofree-radical scavenging) [148]. Arriagada et al. [149] prepared antioxidant mesoporousrated on the antioxidant nanocarrier by the impregnation/sol $\mathrm { S i O } _ { 2 }$ nanoparticles on porous nanoplatforms with rosmarinic acid (nano-RA) as an antioxidant that was loaded on the mesoporous $\mathrm { S i O } _ { 2 }$ nanoparticle surface. Morin flavonoids were incorporated on the antioxidant nanocarrier by the impregnation/solvent evaporation. In addition, the rosmarinic acid and mesoporous SiO2 nanoparticle technique with high drug loading profile was evaluated using $2 3 \%$ wt/wt) compared to bare mesoporouso biorelevant media. The ant $\mathrm { S i O } _ { 2 }$ NPsdant $( 9 \% w / w )$ . In addition, the rosmarinic acid and mesoporous $\mathrm { S i O } _ { 2 }$ nanoparticle (nano-RA) release profile was evaluated using two biorelevant media. The antioxidant activity of the rosmarinic acid and mesoporoushe correct disposition of t $\mathrm { S i O } _ { 2 }$ nanoparticles (nano-RA) was maintained, suggestingmoiety (Figure 6) [149]. These results sugthe correct disposition of the moiety (Figure 6) [149]. These results suggest a promisingtioxidant nanocarrier suitable for future application in drug delivery antioxidant nanocarrier suitable for future application in drug delivery [149]. Table 4 lists different nanomaterial types used as carriers for antioxidant delivery.

![](images/97586f34852d139f4f332ae6d4694f2ce9625ce8be6697f0876b7a1b9af53ad0.jpg)  
resentation showing the preparation of morin-loaded nano-antioxidants ofFigure 6. Schematic presentation showing the preparation of morin-loaded nano-antioxidants of (nano-RA/MH) loaded onto mesoporous silica nanoparticles (MSN). (a) The graphic path from the single components to therosmarinic acid nanocarrier (nano-RA) and (b) morin loading on the nanocarrier (nano-RA/MH) [149]. Copyright 2016, MDPI.

Table 4. Different nanomaterials are used as carriers for antioxidant delivery.   

<html><body><table><tr><td>Nanomaterial</td><td>Antioxidant Agent</td><td>Applications</td><td>Refs</td></tr><tr><td>Conjugates</td><td>Superoxide dismutase</td><td>Supeydxideconverionto</td><td>[150]</td></tr><tr><td>Conjugates</td><td>Superoxide dismutase</td><td>Enhancing drug delivery to the brain</td><td>[151]</td></tr><tr><td>Conjugates</td><td>Catalases</td><td>Hydrogen peroxide conversion to water</td><td>[152]</td></tr><tr><td>Nanozymes</td><td>Catalases</td><td>Hydrogen peroxide conversion to water</td><td>[153]</td></tr><tr><td>GSH-PEGDA oligomer</td><td>Glutathione peroxidase</td><td>Redutinoeian to water</td><td>[154]</td></tr><tr><td>Liposomes</td><td>Vitamins</td><td>ROS scavengxinganuleculationof</td><td>[155]</td></tr><tr><td>Solid lipid nanoparticles</td><td>Carotenoids</td><td>Singlet oxygen quenching, formation of provitamin A carotenoids (free radical scavengers)</td><td>[156]</td></tr><tr><td>Liposomes</td><td>Lycopene</td><td>Singlet oxygen quenching, formation of provitamin A carotenoids (free radical scavengers)</td><td>[155]</td></tr><tr><td>Liposomes</td><td>Polyphenol flavonoid catechins</td><td>re proinflammatory kinases</td><td>[157]</td></tr><tr><td>Quercetin nanosuspensions</td><td>Quecetin</td><td>Protection against LDL oxidation</td><td>[157]</td></tr><tr><td> Silica nanoparticles</td><td>Gallic acid</td><td>Rapid H-atom transfer to diphenyl picryl hydrazine</td><td>[158]</td></tr><tr><td> Silica nanoparticles</td><td>3,4-di-tert-butyl-4- hydroxybenzoic acid</td><td>mpo (LDPE) composites</td><td>[159]</td></tr><tr><td>PEG-coated silver nanoparticles</td><td>Salvianolic acid</td><td>Improved reactive oxygen species (ROS) scavenging and antioxidant activity in</td><td>[160]</td></tr><tr><td>Mesoporous silica nanoparticles</td><td>Poly-tannic acid</td><td>living cells Good antioxidant activity</td><td>[161]</td></tr><tr><td>Mesoporous silica nanoparticles</td><td>Morin</td><td>Potent quencher of singlet molecular oxygen (1O2),HO: scavenger</td><td>[162]</td></tr><tr><td>Ceria nanoparticles</td><td>(PEGdledrophoglyhoipids</td><td>cioxitiltxedivionos</td><td>[163]</td></tr><tr><td>PLGA-PEG</td><td>Curcumin</td><td>Neuroprotection</td><td>[164]</td></tr></table></body></html>

# 4. Antimicrobial Materials

Antibacterial agents are used in the biomedical sector, textile industry, water treatment, and food industries [165]. The antimicrobial characteristics of nanoparticles are influenced by several factors [166], including size, shape, and the type of encapsulated antibiotics drug. For instance, nanoparticles with angular shapes (e.g., triangular, cubic, tetrahedral) cause mechanical harm to the microbial membrane, and this contributes to increased microbial growth inhibition compared to spherical nanoparticles [167]. Based on their antimicrobial properties, antimicrobial nanoparticles can be classified into four main categories: antibacterial, antifungal, antiviral, and antiparasitic nanoparticles [168]. Table 5 lists these different types of antimicrobial nanoparticles, their mode of action, and targeted microorganisms. For millennia, metals and metallic salts have been used for their antibacterial properties. For instance, silver pots have been used for drinking water since 4000 BCE [169].

Surface functionalization allows the production of antibacterial nanoparticles with two different antibiotics to concomitantly kill, for instance, Gram-positive (encapsulated)

and Gram-negative (attached) bacterial strains. Inorganic disinfectants, such as metal oxide nanoparticles, are gaining popularity because of the limitations of organic disinfectants, such as toxicity to humans [166,170]. Currently, nanophysics researchers are investigating the effects of different metallic nanoparticles in bacteria. The antibacterial mechanism of metallic nanoparticles is still debated, but three major mechanisms are proposed: (i) reactive oxygen species (ROS) formation; (ii) metal ion release from metallic nanoparticles; and (iii) metallic nanoparticles interaction with the cell membrane. Metallic nanoparticles display higher antibacterial effects than their salts. The antibacterial function is often influenced by the size of the metallic nanoparticles [20].

Table 5. Classification of antimicrobial nanomaterials based on their antimicrobial properties, their different modes of action, and targeted microorganisms.   

<html><body><table><tr><td>Function</td><td>Mode of Action</td><td>Nanomaterial</td><td>Target Microorganism</td><td>Ref</td></tr><tr><td rowspan="7">Antibacterial</td><td rowspan="7">Interaction with DNA,resulting in DNA replication inhibition ROS production Interaction with sulfur-containing proteso</td><td rowspan="4">Silver nanoparticles (Ag NPs)</td><td>Bacillus subtilis Staphylococcus aureus</td><td>[171] [172]</td></tr><tr><td></td><td></td></tr><tr><td>Methilinrestat</td><td>[173]</td></tr><tr><td>staphylococci Escherichia coli 0157:H7</td><td>[174]</td></tr><tr><td rowspan="3">Titanium xid aspartiles Copper oxide nanoparticles</td><td>Staphylococcus aureus</td><td>[175] [176]</td></tr><tr><td>Pseudomonas fluorescens</td><td></td></tr><tr><td>Bacillus subtilis</td><td>[177] [178]</td></tr><tr><td rowspan="4"></td><td rowspan="2">(CuO NPs)</td><td>Listeria monocytogenes</td><td>[179]</td></tr><tr><td>Candida spp.</td><td>[180]</td></tr><tr><td rowspan="3">Titanium oxide nanoparticles (TiO2 NPs)</td><td>Penicillium expansum</td><td>[181]</td></tr><tr><td> Aspergillus niger spp.</td><td>[182]</td></tr><tr><td>Penicillium oxalicum</td><td>[183]</td></tr><tr><td rowspan="4"></td><td>Siver nanoparticles (Ag NPs) Magnesium oxide</td><td>Candida spp.</td><td>[184]</td></tr><tr><td>nanoparticles (MgO NPs)</td><td>Saccharomyces cerevisiae Candida albicans</td><td>[185] [186]</td></tr><tr><td rowspan="2">Gold nanoparticles (Au NPs)</td><td>Human immunodeficiency virus</td><td>[187]</td></tr><tr><td>Influenza virus</td><td>[188]</td></tr><tr><td rowspan="4">Antiviral Inith</td><td rowspan="2"> Silver nanoparticles (Ag NPs)</td><td>Herpes simplex virus</td><td>[189]</td></tr><tr><td>Respiratory syncytial virus</td><td>[190]</td></tr><tr><td rowspan="2">Titanium oxide nanoparticles (TiO2 NPs)</td><td>Inactivation of bacteriophages</td><td>[191]</td></tr><tr><td>Ina tivationof Qb ad</td><td>[192]</td></tr><tr><td rowspan="4">Antiparasitic</td><td rowspan="4">Inhibition of promastigote proliferaicit parasitic infection</td><td rowspan="3">Silver nanoparticles (Ag NPs)</td><td>Leishmania tropica</td><td>[193]</td></tr><tr><td>Leishmania infantum</td><td>[194]</td></tr><tr><td>Entamoeba histolytica</td><td>[195]</td></tr><tr><td rowspan="2">Copper oxide nanoparticles (CuO NPs)</td><td>Entamoeba histolytica</td><td>[196]</td></tr><tr><td></td><td>Cryptosporidium paroum</td><td>[197]</td></tr></table></body></html>

The antimicrobial properties of silver nanoparticles $( \mathrm { A g N P s } )$ are very well known, and when compared to other metallic nanoparticles, they have higher toxicity against microorganisms [198,199]. As they are currently used as an alternative to antibiotic treatment, $\mathrm { A g }$ NPs are often referred to as “next-generation antibiotics”. The antimicrobial potential of $\mathrm { A g }$ NPs has been tested in many different pathogens, including Gram- $\cdot ( + ) / ( - )$ bacteria, viruses, and fungi. These particles also show antimicrobial activity in many multidrug-resistant bacteria [200,201]. Despite the many studies on $\mathrm { A g N P s , }$ , the precise mechanism of their antimicrobial effect is still unknown [202]. It is thought that their antibacterial activity relies mainly on the generation of $\mathrm { A g ^ { + } }$ ions. Some studies showed that ${ \mathrm { A g } } ^ { + }$ ion generation is influenced by the nanoparticle’s surface area. Specifically, nanoparticles with a larger surface area generate higher $\mathrm { A g ^ { + } }$ concentrations, which leads to enhanced antimicrobial activity. Conversely, nanoparticles with a smaller surface area generate lowertion, Ag NPs’ toxic effects against bacteria are influenced by the $\mathrm { A g ^ { + } }$ concen-otrations and thus display lower antimicrobial activity [203]. This also indicates that thehemical properties. Many studies have shown that Ag NPs disrupt sevantibacterial activity is linked to the amount and quality ofhways and cellular pathways inside the bacteria $\mathrm { A g ^ { + } }$ ions generated. In addition,ll [35,204,205]. The $\mathrm { A g N P s ^ { \prime } }$ toxic effects against bacteria are influenced by the nanoparticle’s physicochemical properties. Many studies have shown that $\mathrm { A g N P s }$ disrupt several metabolic pathways and cellular pathways inside the bacterial cell [35,204,205]. The antibacterial activity ofng) and the medium (light, oxidative species, ligands, ionic strengt $\mathrm { A g N P s }$ is influenced by several factors related to the nanoparticles (size, shape, coating) and thewhereby these factors can modify the antibacterial activity of Ag NPs medium (light, oxidative species, ligands, ionic strength). The mechanisms whereby these7) and include ligand replacement, oxidative dissolution, Ag+ions refactors can modify the antibacterial activity ofn of the Ag surface, passivation layer p $\mathrm { A g N P s }$ are many (Figure 7) and include lig-ing, silver speciation, and and replacement, oxidative dissolution, ${ \mathrm { A g } } ^ { + }$ ions reduction, passivation of the $\mathrm { A g }$ surface, passivation layer puncturing, silver speciation, and nanoparticle aggregation [206]. These phenomena may also be influenced by some chemical species. For instance, chloride canstance, chloride can accelerate or slow down corrosion in the function accelerate or slow down corrosion in the function of its concentration. Therefore, the an-n. Therefore, the antimicrobial activity of Ag NPs should be assessed in timicrobial activity ofns to limit/preven $\mathrm { A g N P s }$ should be assessed in controlled conditions to limit/preventpected changes in the system. Specifically, Ag unexpected changes in the system. Specifically, $\mathrm { A g N P s }$ must be stored in the dark and without oxygen. Antibacterial mechanisms can be classified in two groups: non-oxidative and oxidative mechanisms (Figure 7).roups: non-oxidative and oxidat

![](images/c08a971a3921ff3ee22e6ba71a40f27e71ed877022270e861d6c0f9635bd1476.jpg)  
representation of several factors that influence silver nanoparticles’ (Ag NPs) Figure 7. Schematic representation of several factors that influence silver nanoparticles’ (Ag NPs) . antibacterial activity.

The antimicrobial and antibiofilm properties of $\mathrm { T i O } _ { 2 }$ NPs are widely known and are active against pathogens, such as fungi, viruses, parasites, and bacteria. Recently, the use of $\mathrm { T i O } _ { 2 }$ 2NPs in the food industry has started and has been approved by the FDA for their ustry has started and has been approved by the FDA for their use in drugs, use in drugs, food, and cosmetics [207]. The quantum size effects and photocatalytic effects of these NPs made them ideal in various antimicrobial applications, such as antimicrobial coatings on medical devices, air, and water purification. Anti Gram-positive and Gramnegative effects of $\mathrm { T i O } _ { 2 }$ NPs are well known, but the bactericidal activity of these NPs has been enhanced by plant extracts, such as Garcinia zeylanica. The combination of inherent antimicrobial activity with plant extract and photocatalytic property of $\mathrm { T i O } _ { 2 }$ NPs have enhanced their potency as microbicidal agents [208]. ROS generated by $\mathrm { T i O } _ { 2 }$ NPs destruct the microorganisms by oxidizing the cell membrane. Apart from antimicrobial activity due to photocatalytic activity $\mathrm { T i O } _ { 2 }$ NPs, these nanoparticles also show activity in the absence of light by direct contact and adsorption of cells and cause the loss of membrane integrity [209,210]. The antimicrobial properties of $\mathrm { C u N P s }$ are widely known on various species of bacteria (e.g., bacillus subtilis, methicillin-resistant staphylococcus aureus, Pseudomonas aeruginosa, salmonella choleraesuis). The level of agglomeration of Cu NPs decides the microbicidal activity, which is a common issue with them. Sammlersized Cu NPs result from a reduction in the agglomeration, which increases the surface area and interaction with bacterial membranes that lead to more toxicity. Hydroxyl radicals were produced from the ionic and metallic forms of copper that damage essential DNA and proteins [211,212]. Many other nanoparticles, such as Si NPs, CaO NPs, MgO NPs, and $\mathrm { A l } _ { 2 } \mathrm { O } _ { 3 }$ NPs, have good antimicrobial properties with good biocompatibility. Most of them will act by damaging the bacterial cell wall [212].

# 5. Gene Therapy

Gene therapy is a method in which genes are modified to prevent and/or treat disease. With this revolutionary technique, clinicians can treat a disease simply by incorporating the modified gene into the patient’s cells, without the need for surgery or drugs. Depending on the disorder, gene therapy may be used to add a functional copy of a gene that is not working properly or to switch off the gene that is causing the problem. These modified genes are delivered into the cells using a vector (i.e., a genetically modified transporter). Due to their nanometric size, large surface-to-volume ratio, and stability, nanoparticles are attractive agents as gene carriers [83].

Surface modifications may be used to bind an infinite number of ligands and receptors [207]. Alternatively, nanoparticles may encapsulate and release nucleic acids into target cells, with superior efficacy in gene therapy compared with non-viral vectors and without immunogenicity. Liposomes have been studied as medication and also as a DNA delivery device [208]. For instance, gene therapy in which liposomes act as vectors has been used to treat corneal diseases [209], cardiovascular diseases [210], cystic fibrosis [211], and cancer [212]. In lung carcinoma, cancer with low survival rate, DOTAP:cholesterol liposomes were used to deliver the tumor suppressor gene FUS1 in mice harboring lung cancer xenografts [213]. Liposome–DNA complexes were synthesized using a simple mixing method. The complex efficacy in inhibiting tumor growth and metastasis development was evaluated [37].

Designing nanoparticles for gene delivery is not easy because many factors must be taken into account. First, nanoparticle functionalization should bring biocompatible layers and contribute to maintaining the structural integrity and activity of the transported genes/drugs in the biological fluids. Second, nanoparticle production, like for any therapeutic product, must take into account the following issues: physicochemical properties, biopharmaceutical properties, and pharmacological properties. Therefore, nanoparticles should have the capacity to treat directly, and this requires new design parameters. Studies on the Administration, Distribution, Metabolism, and Excretion (ADME) of nanoparticles should be designed to take into account their aggregation and surface characteristics (Figure 8) [120].

![](images/31b96cbcc77e8a28dccf39f826d32164706af2743a0f0849f870be633f7516a9.jpg)  
atorial approaches based on organic nanoparticles (ONP) for gene therapy are Figure 8. Combinatorial approaches based on organic nanoparticles (ONP) for gene therapy are her therapies [214]. Copyright 2017, Trends in Biotechnology. associated with other therapies [214]. Copyright 2017, Trends in Biotechnology.

In plant science, gene delivery plays a vital part in the growth of new plant varieties nce, gene delivery plays a vital part in the growth of new plant varieties and the development of drought-resistant, pest-resistant, high-yield plants [215]. The pment of drought-resistant, pest-resistant, high-yield plants [215]. The main inherent obstacle to gene delivery in plants is the biomolecule movement within bstacle to gene delivery in plants is the biomolecule movement within cells through the rigid and multilayered cell wall. Many delivery methods have several disadvantages, including low production, contamination, and foreign DNA incorporation into the plant genome [83,216]. The functionalization of biomaterials allows the developncluding low production, contamination, and foreign DNA incorporation ment of bionanomaterials to deliver a gene into plant cells through a nanoneedle that can nome [83,216]. The functionalization of biomaterials allows the develop-overcome the existing limitations in delivering biomolecules to plants [217]. Intracellular materials to deliver a gene into plant cells through a nanoneedle that can gene delivery has been performed using conventional synthetic vehicles, such as cationic lipids, dendrimers, and polymers. It safeguards DNA from nuclear enzyme degradation, ensures efficient movement inside the cells and tissues, as well as the active gene transfer s been performed using coto the cell nucleus. Mesoporous $\mathrm { S i O } _ { 2 }$ ntional synthetic vehicles, such as cationic nanoparticles have also been tested to deliver genetic rs, and polymers. It safeguards DNA from nuclear enzyme degradation, material to plant cells. Traditional methods of gene transfer have some drawbacks, such movement inside the cells and tissues, as well as the active gene transfer as the limited amount of delivered DNA, cell degradation, limited plant diversity, and s. Mesoporous SiO nanoparticles have also been tested to deliver genetic toxicity; however, new vehicles for activators, nucleic acids, and proteins into vegetable cells are now available showing higher efficiency and additional safety features [218].

# 6. Biosensors

Biosensors are devices that combine organic components (e.g., antibodies, enzymes) and an electronic element to yield a detectable signal that can be quantified [219]. The electronic elements detect the physiological change produced by the interaction of theomponent with environmental chemical or biological elements [220,221]. A typical biosenorganic component with environmental chemical or biological elements [220,221]. A typicalor consists of five main components (Figure 9): (i) the analyte, a substance the presence and biosensor consists of five main components (Figure 9): (i) the analyte, a substance themount of which are detected [222]; (ii) the receptor, an organic molecule that can detect the presence and amount of which are detected [222]; (ii) the receptor, an organic molecule thatanalyte [221]; (iii) the transducer, a device that converts the physiological change occurring can detect the analyte [221]; (iii) the transducer, a device that converts the physiologicalfollowing the analyte-receptor interaction to a quantitatively measurable optical or electrical change occurring following the analyte-receptor interaction to a quantitatively measurable optical or electrical signal [220]; (iv) the electronic part that receives and quantifies the signals from the transducer; and (v) the display, an interpretation system (a computer and a printer) to display the response output in a manner that can be understood by the user [223].

![](images/bc455258f14f66dcbbf2709a8552de8bbf7ee7ed05f7bfe5721cbd2d3413196f.jpg)  
Figure 9. Schematic representation of the components of a typical biosensor and of the different types igure 9. Schematic representation of the components of a tyof bioreceptors and transducers. Image created by Biorender.

The efficient signal collection is one of the main challenges in biosensor development The efficient signal collection is one of the main challenges in biosensor development (transduction). The interaction of the analyte with the biological element is converted (transduction). The interaction of the analyte with the biological element is converted into into gravimetric, electrochemical, magnetic, electro-chemiluminescent, or optical signals gravimetric, electrochemical, magnetic, electro-chemiluminescent, or optical signals using using a transducer. Engineered nanomaterials have a greater electrical conductivity, are a transducer. Engineered nanomaterials have a greater electrical conductivity, are na-nanosized, may be used to amplify desired signals, and are biocompatible. Due to their nosized, may be used to amplify desired signals, and are biocompatible. Due to their po-potential to trap huge amounts of specific binding units and to operate as a conductive ential to trap huge amounts of specific binding units and to operate as a conductive me-medium, nanomaterials are good candidates to improve the biosensor detection sensitivdium, nanomaterials are good candidates to improve the biosensor detection sensitivity ity for specific molecules. Carbon nanotubes, nanodiamonds, semiconductor quantum for specific molecules. Carbon nanotubes, nanodiamonds, semiconductor quantum dots, dots, polymer nanofibers, and graphene are some of the most studied nanomaterials for polymer nanofibers, and graphene are some of the most studied nanomaterials for bio-biosensing applications. Indeed, carbon compounds can be used to conjugate biomolecules (enzymes, antibodies, DNA, cells). Nanomaterials can improve biosensor performance (better sensitivity and lower limit of detection). Nanomaterials with optimal surface-to-volume ratio, chemical activity, mechanical strength, electrocatalytic capabilities, and diffusivity can profoundly influence biosensor performance. Moreover, nanomaterials biocompatibility is a key feature in building biosensors to monitor bacteria, viruses, DNA, and other biomolecules [224].

Nanomaterial-based biosensors have been used for diagnostic purposes through the detection of specific biomarkers in biological samples. For example, Tang et al. manufactured a complex biosensor for the detection of prostate cancer biomarkers by using magnetic nanoparticles as a carrier for the labels and as separators. Specifically, the magnetic nanoparticles used for the amperometry detection of four prostate cancer biomarkers (interleukin-6, prostate-specific antigen, platelet factor-4, and prostate-specific membrane antigen) were labeled with horseradish peroxidase (HRP) and secondary antibodies (Ab2) to yield Ab2-MNP-HRP beads. Then, beads were resuspended in a phosphate-based buffer and incubated with a mixture of protein standards to detect the four markers within this mixture. Afterward, the mixture was transferred to the sensing compartment labeled with primary antibodies against the four markers under which ring-shaped magnets were fixed to facilitate the bead migration to the sensing surface. Following the incubation and washing steps, the addition of the HRP substrate enabled the development of a detectable and measurable electrochemical signal [225]. Table 6 lists the benefits of various nanomaterials.

Table 6. Examples of different nanomaterials and their key benefits in various applications.   

<html><body><table><tr><td>Nanomaterial</td><td>Dimentionality</td><td>Key Benefits</td><td>Ref</td></tr><tr><td>Spherical metallic nanoparticles</td><td>Zero-dimensional (0D)</td><td>Immobilization of bio-receptors Improved analyte loading Strong catalytic characteristics</td><td>[226]</td></tr><tr><td>Spherical quantum dots</td><td>Zero-dimensional (0D)</td><td>Excellent fluorescence, Charge carrier quantum confinement size-adjusted band energy</td><td>[227]</td></tr><tr><td>Nanorods</td><td>One-dimensional (1D)</td><td>Excellent plasmonic materials Size-adjustable energy regulation to produce specific field responses</td><td>[228]</td></tr><tr><td>Nanowires (1D)</td><td>One-dimensional (1D)</td><td>Superiorsngeconderitins</td><td>[228]</td></tr><tr><td>CarboD and 2Dterials</td><td>One and twan-dimensional</td><td>Higfuriorchalizatonductinial</td><td>[229]</td></tr></table></body></html>

# 7. Tissue Engineering

Tissue engineering is a multidisciplinary approach to develop structures that are made of biological components (e.g., cells, stimulatory molecules) and biomaterials that can mimic the native organ/tissue. Engineered tissues may be used at the place of conventional organ/tissue transplant procedures to lower the cost burden [230,231]. The rapidly evolving nanotechnological and fabrication techniques have allowed the incorporation of various biocompatible nanomaterials in tissue engineering, including nanoporous scaffolds and nanofiber membranes [232,233]. Nanomaterials have been used in various tissue engineering applications (periodontal, neural, bone, and skin tissue engineering) [234]. Nanomaterials can contribute to finely tuning the scaffold characteristics, particularly the mechanical strength, and regulating the release of bioactive molecules (growth factors, cytokines, inhibitors, genes, drugs) [235,236].

In dental tissue engineering, novel treatments are required for the effective reconstruction of periodontal tissue damage due to the gradual loss of the self-healing capacities of periodontal tissue with age. Nanomaterials have emerged as promising candidates for the reconstruction of periodontal tissue [237]. Nanomaterials are interesting materials in dental tissue engineering as (i) nano-coatings for dental implants, (ii) nanofillers to enhance the mechanical properties of the biomaterials used in dental tissue engineering, (iii) antimi-ents to prevent oral infections, and (iv) as ingredients for novel personal crobial agents to prevent oral infections, and (iv) as ingredients for novel personal carend toothpaste [237]. Xi et al. prepared multifunctional vesicles by co-asproducts and toothpaste [237]. Xi et al. prepared multifunctional vesicles by co-assemblingε-caprolactone)-block-poly(lysine-stat-phenylalanine) and poly(ethylene poly(ε-caprolactone)-block-poly(lysine-stat-phenylalanine) and poly(ethylene oxide)-blockpoly(ε-caprolactone) that were loaded with ciprofloxacin hydrochloride (an antibiotic used to treat periodontitis) (Figure 10). Their in vitro and in vivo experiments showed that theseo treat periodontitis) (Figure 10). Their in vitro and in vivo experiments multifunctional vesicles eliminated biofilms made by Escherichia coli and Staphylococcusse multifunctional vesicles eliminated biofilms made by Escherichia coli aureus and greatly contributed to periodontitis treatment [238].cus aureus and greatly contributed to periodontitis tr

![](images/6c3a2fdd656770d23e2165a9b2920cfe5b6dbb75e6d34d18c9431b600227feeb.jpg)  
s displaying antibacterial activity and good antibiotic delivery capacity for the Figure 10. Vesicles displaying antibacterial activity and good antibiotic delivery capacity for the iofilm-induced periodontitis. (a) Co-assemblage of multifunctional corona vesi-management of biofilm-induced periodontitis. (a) Co-assemblage of multifunctional corona vesicles. ation of ciprofloxacin within the multifunctional corona vesicles. (c) Antibacterial (b) Encapsulation of ciprofloxacin within the multifunctional corona vesicles. (c) Antibacterial activity ltifunctional corona vesicles to remove dental plaque biofilms produced by bacte-of the multifunctional corona vesicles to remove dental plaque biofilms produced by bacteria [238]. ht 2019, American Chemical Society. Copyright 2019, American Chemical Society.

In humans, the nervous system is an extremely complex system that comprises the the nervous system is an extremely complex system that comprises the peripheral nervous system (PNS, motor, and sensory nerves) and the central nervous ous system (PNS, motor, and sensory nerves) and the central nervous sys-system (CNS, spinal cord, and the brain). The nervous system lacks self-healing capacities; l cord, and the brain). The nervous system lacks self-healing capacities; therefore, any trauma or disease-related damage to the CNS or PNS is permanent [239]. auma or disease-related damage to the CNS or PNS is permanent [239]. The frequency of neurological damage increases with age and is becoming a public health issue due to the aging population [240]. Currently, protocols of neurological damage treatment are based on autologous or allogeneic cell grafts and neurosurgery. However,22 of 43 these approaches often require the inhibition of the immune response (grafts) and additional surgical procedures and show moderate effects [241].

Nanofibers were initially defined as fibers with diameters below $1 0 0 \mathrm { n m }$ . However, the scope of nanofibers has been broadened in recent years, with all fibers of diameter less than, self-assembling, solvent dispersion, centrifugal spinning, hydrother$1 \mu \mathrm { m }$ included. Several techniques have been reported to prepare nanofibers, includingng [242–245]. Nanofibers present diverse applications, such as mothe splitting of bicomponent fibers, melt-blowing, physical drawing, flash-spinning, phaseseparation, bio-sensing, crop protection, bioremediation, anti-counterseparation, self-assembling, solvent dispersion, centrifugal spinning, hydrothermal, and electrospinning [242–245]. Nanofibers present diverse applications, such as molecular filters, bioseparation, bio-sensing, crop protection, bioremediation, anti-counterfeiting, andr molecular filtration and shows potential for forming a scaffold for proantibacterial. The high surface area to weight ratio of nanofibers makes an ideal substratepplications against biochemical attacks [246,247]. Nanofibrous materials for molecular filtration and shows potential for forming a scaffold for protective clothingst for tissue engineering applications, including skin regeneration. Nanapplications against biochemical attacks [246,247]. Nanofibrous materials are gaininges mimic the native extracellular matrix and promote the adhesion of interest for tissue engineering applications, including skin regeneration. Nanofibrous structures mimic the native extracellular matrix and promote the adhesion of various cells and soluble factors that may promote cell function and tissue regeneration (Figure 11) [248].

![](images/8190ddcdbee376fe5b0fc15d494fc7f3a8cf79f8b4fe5ae33c5f6dbad0a8af29.jpg)  
c figure to show how electrospun nanofibers promote the differentiation of var-Figure 11. Schematic figure to show how electrospun nanofibers promote the differentiation of otent stem cells into different lineages [248]. Copyright 2020, Wiely. various types of pluripotent stem cells into different lineages [248]. Copyright 2020, Wiely.

Wound healing is a natural process that involves hemostasis, inflammation at the site ing is a natural process that involves hemostasis, inflammation at the site of injury, the proliferation of keratinocytes, and remodeling [249]. Based on the healing liferation of keratinocytes, and remodeling [249]. Based on the healing time, skin wounds are categorized in chronic and acute wounds [250]. Compared with s are categorized in chronic and acute wounds [250]. Compared with acute wounds, chronic wounds need much more time to heal, and they are mainly observed in people with comorbidities (e.g., diabetes, obesity) [251]. The formation of a new blood vessel (angiogenesis) is crucial for the wound healing process because it is required for with comorbidities (e.g., diabetes, obesity) [251]. The formation of a new the flow of nutrients, waste, and oxygen to the wound site. It also accelerates the rate of granulation tissue formation. Any angiogenesis impairment will result in a chronic wound [252]. Therefore, during the treatment of a skin wound, the successful formation of the new blood supply must be taken into consideration. Currently, various protocols are available for chronic wound management, such as ozone therapy, hyperbaric oxygen therapy, oxygen therapy, and negative pressure wound therapy [253]. Moreover, for large skin wounds, autologous skin grafts are considered the gold standard. However, their use is limited by the small amount of donor tissue that can be obtained and by the morbidity at the donor site [254].

Recently, nanomaterials have been proposed as candidates for nanostructured scaffold architectures for the management of large skin wounds. This is explained mainly by their distinct physicochemical features, particularly their nanoscale dimensions and their very high surface-area-to-volume ratio. Nanomaterials can also be used in skin tissue engineering as delivery vehicles of therapeutic molecules [19]. Randeria et al. prepared Au NPs functionalized with small interfering RNAs against ganglioside-mono sialic acid 3 synthase (GM3S), thiolated ethylene glycol, and dispersed in Aquaphor. GM3S is an enzyme the expression of which is increased in diabetic mice and that causes insulin resistance, thus slowing down wound healing. The authors found that in diabetic mice, these functionalized Au NPs could downregulate GM3S expression and that skin wounds in nanoparticle-treated mice fully healed in 12 days compared with untreated mice [255].

# 8. Agriculture and Food Industry

Nanotechnology is used in agriculture to enhance food production and also to improve/preserve the nutritional content, quality, and safety of foods. Fertilizers, insecticides, herbicides, and plant growth factors/regulators are used to enhance agricultural yields. Nanotechnology is also more and more implicated in the development of approaches to stimulate seed germination, plant growth, and plant defenses [256]. Metal nanoparticles (Ag NPs and Cu NPs) have been particularly studied in plant science. Their organic synthesis is very expensive and involves dangerous chemicals [257]; however, nanoparticle surface functionalization allows the accommodation of more micronutrients in one nanoparticle for efficient delivery to the plants. These micronutrients may enhance productivity and increase the nutrient content in agriproducts. Carbon nanomaterials are commonly used in agriculture because they can influence the plant’s metabolic functions, and ultimately, its growth. Therefore, these nanomaterials, used at very small concentrations, can go into the plant cells and could be an effective answer to increase crop yield and fruit production [258].

The plant’s response to nanomaterials is influenced by different factors, including the nanoparticle’s size, shape, application process, and chemical and physical properties. Nanomaterials can be used as nanostructured fertilizers to increase the absorption and efficiency of traditional fertilizers (nutrients and phosphates). It has been shown that soybean growth and seed yield are increased by $3 3 \%$ and $2 0 \%$ , respectively, when treated with hydroxyapatite nanoparticles (phosphorous nano-fertilizers) compared with normal phosphorous fertilizers. Moreover, nano-fertilizers are used at lower concentrations, thus limiting the nutrient spreading to runoff or groundwater and reducing the risks of degradation and toxic effects due to over-application [259]. Mung bean, cucumber, and rapeseed plants have been treated with $Z _ { \mathrm { { n O } } }$ , ${ \mathrm { F e } } _ { 2 } { \mathrm { O } } _ { 3 }$ , $\mathrm { T i O } _ { 2 }$ , and CuONPs, as nano-fertilizers, by direct addition to the soil or through irrigation or foliar application [260,261]. In tomato cultures, soil supplements have doubled the number of flowers and fruits, probably by activating plant-based genes/proteins [262].

In wheat cultures, chitosan nanoparticles have been used to manage the release of nitrogen, phosphorus, and potassium via foliar intake [263]. In terms of environmental degradation, organic nanoparticles are more appropriate. However, their nutrient supply advantages compared with conventional fertilizers need to be more rigorously demonstrated [259]. Microgel-based fertilizers biofunctionalized for the delivery of the micronutrients to the plant have been developed for foliar delivery of nutrients [264]. Nano-fertilizers distributed in a controlled manner can boost crop development, yield, and productivity. Crop enhancement can also be obtained by gene transfer using nano-based target delivery approaches. Nano-pesticides can protect crops effectively. Precision farming is considerably promoted by the development of nanosensors and digital controls. Plant drought tolerance and soil enrichment can both benefit from nanomaterials. Figure 12 shows some potential applications of nanomaterials in the animals and agriculture industry, i.e., nano-fertilizers and nano-pesticides, which stimulate animal and plant growth using24 of 43 nanomaterials; smart monitoring for animals and plants using nanosensors by wireless communication devices and smart packaging.

# Bionanotechnology

![](images/fb75809a0e4865f1f4086dab4f44652bb8f3669dc9b1a207621bc3cf8c6a98ad.jpg)  
Figure 12. Potential applications of nanomaterials in the animal and agriculture industry. Increase l applications of nanomaterials in the animal and agriculture industry. Increase the productivity of the crop using nano-pesticides and smart packaging; Improve the quality of the the crop using nano-pesticides and smart packaging; Improve the quality of the soil using nano-fertilizers; Stimulate animal and plant growth using nanomaterials; Provide smart tilizers; Stimulate animal and plant growth using nanomaterials; Provide smart monitoring for animals and plants using nanosensors by wireless communication devices. Image mals and plants uscreated by Biorender.

Fertilizers significantly increase farm productivity. However, as their over use irreversibly changes the soil chemistry, nanomaterial-based fertilizers are more frequently gnificantly increase farm productivity. However, as their over use irre-proposed to increase the fertilizer uptake by plants and to minimize the amount of fertilizer the soil chemistry, nanomaterial-based fertilizers are more frequently needed, and thus, its concentration in the soil. Sustainable farming implies minimal use ase the fertilizer uptake by plants and to minimize the amount of ferti-of chemicals to protect the environment and various plant/animal species against extinction [265]. Nanomaterials can boost crop growth/yield by facilitating the fertilizer uptake by the plant, thus ensuring minimal use of inputs and encouraging site-oriented, regulated to protect the environment and various plant/animal species against ex-nutrient supply. Indeed, nanotechnology research (and funding) on plant protection has nomaterials can boost crop growth/yield by facilitating the fertilizer up-been growing to guarantee better crop yields. Many plants exposed to toxic concentrations of metal ions and nanoparticles attempt to prevent or reduce uptake into root cells by restricting metal ions (nanoparticles) to the apoplast, binding them to the cell wall or cellular exudates, or by inhibiting long-distance transport [266].

Through effective farming, irrigation, and utilization of quality seeds, agricultural yields can be improved by $3 5 { - } 4 0 \%$ . The use of nano-formulation fertilizers strongly improves crop productivity. Carbon nanoparticles in fertilizers, for example, increase the yield of rice (by $1 0 . 2 9 \%$ ), soybean (by $1 6 . 7 4 \%$ , winter wheat (by $2 8 . 8 1 \%$ ), vegetables (by $1 2 . 3 4 \mathrm { - } 1 9 . 7 6 \%$ ), and spring maize (by $1 0 . 9 3 \%$ ). Nanomaterials are the best strategy to bring nutrients to plants that are extremely porous at the nanoscale through the activation of different biological plant processes. As a consequence, nano-fertilizers may increase the absorption of nutrients through the plant pores [267]. Furthermore, extensive research has clearly shown that reducing the nanomaterials size increases the surface mass of particles, thus adsorbing and slowly and steadily desorbing a vast amount of nutrient ions over a long period [268]. Surface-modified nanomaterials-based fertilizers can accommodate more than one nutrient into the same carrier. Thus, nano-fertilizer formulations enhance the growth of nutritionally healthy crops and increase yields. It should be remembered that improved crop production will push farmers to increase the use of that product (Figure 12) [269].

To protect the crops from diseases caused by fungi and other plant pathogens and to increase productivity, pesticides and herbicides can be encapsulated into surface-functionalized nanoparticles. The use of this nano-formulation type has increased exponentially. Traditional crop management practices involve the large-scale use of fungicides, herbicides, and insecticides at large concentrations. Nanotechnology has been extensively employed to regulate the application of phytopathogens, and nano-fungicides and nano-pesticides are now commonly used in agriculture [270]. Encapsulation in nanoparticles allows the gradual and regulated release of the pesticide active ingredients, often leading to the decrease of pesticide utilization and, consequently, of their emissions into the atmosphere. The nanosensor-based detection of pathogens may also reduce the risk of disease in addition to nano-pesticides [265].

Fast-Moving Consumer Goods (FMCG) are fast-selling consumer items, such as household cleaning materials, toiletries, cosmetics, pharmaceuticals, and also include many non-sustainable items, such as batteries, glassware, and light bulbs. However, the main segment consists of food and beverage items that have a limited shelf life, either because of strong market demand or because the commodity depreciates rapidly or is perishable. Therefore, the packaging of such products is crucial to reduce waste and to avoid product damage during its transport to stores and the consumers’ houses [271]. Nanotechnology research in the food industry is focused on the development of techniques for food manufacturing, packaging, and distribution. Many food items are now supplemented with nanoparticles that enhance nutrient and bioactive distribution mechanisms, taste and texture, and microbiological safety. In the field of food production and labeling, nanoparticles are also used as antimicrobials or as extremely reactive biosensors for the identification of bacteria, allergens, pollutants, and degradants that may influence food quality and health [272]. Therefore, today, many food products contain nanoparticles (intentionally introduced or due to contamination). Nanomaterial pollution may also originate in the agricultural environment where many nanomaterials are used (pesticides and fertilizers, cattle protection, poultry development) [273]. Table 7 summaries the nanomaterial applications in the agri-food sector

Table 7. Summary of nanotechnology and nanomaterials applications in agri-food sector.   

<html><body><table><tr><td>Agriculture</td><td>Food Processing</td><td>Food Packaging</td><td>Supplements</td><td>References</td></tr><tr><td>interaction</td><td>biailebityulatinfoent of nutraceuticals</td><td>attached to antibodies</td><td>Nutientaserption nanosized powders</td><td>[274-277]</td></tr><tr><td></td><td> Flavor enhancement using</td><td></td><td> Celonge angratslsr</td><td>[278-281]</td></tr><tr><td>Cotrolledeiyery of</td><td>Nanopityileses</td><td></td><td>Nutraceutical nanoenanpesulation for absorption and stability</td><td>[83,281-283]</td></tr><tr><td></td><td>Replacement of meat</td><td></td><td>Coiled nanoparticles</td><td>[83,265,284,285]</td></tr><tr><td>Vaccine delivery using nanocapsules</td><td>Removalive bindings by nanoparticles from food</td><td>Heat resistant films with silicate nanoparticles</td><td>absorptionbydistesing vitamindroples</td><td>[286-289]</td></tr></table></body></html>

# 9. Risks of Exposure to Nanomaterials

Despite their advantages, nanomaterials may also be associated with risk factors. Nanoparticles can adversely affect different organs/tissues in the body and can be associated with different disorders (Figure 13). Nanoparticle exposure can promote the development of neurological disorders (e.g., Parkinson’s disease and Alzheimer’s disease), lung (asthma, bronchitis, emphysema, and cancer), and cardiovascular diseases (atherosclerosis, arrhythmia, thrombosis, and hypertension). In addition, exposure to nanoparticles can cause skin irritation, dermatitis, urticaria, and other skin problems.

Various factors influence the toxicity of the different nanomaterials, particularly the exposure time and dose. The exposure dose can be determined by multiplying the molar concentration of nanoparticles in the medium by the exposure time [63]. However, other factors (e.g., aggregation and concentration effects) may also influence the nanoparticle’s toxicity. For instance, some nanoparticles can aggregate. These aggregates (in the micrometer range) might not easily penetrate the body, and thus their toxicity is decreased. Toxicity is also influenced by the nanoparticle’s size because nanoparticles with a size of ${ \sim } 1 0 \mathrm { n m }$ can go through the cell membrane, and thus, can be more toxic than larger nanoparticles [288]. Nanoparticles’ shape also influences their toxicity, which may vary in function of the aspect ratio. For instance, $1 0 ~ { \mu \mathrm { m } }$ asbestos fibers cause lung cancer, whereas smaller fibers induce mesothelioma and asbestosis [289]. Similarly, the nanoparticle effect is inversely proportional to the nanoparticles size and directly proportional to the surface area. The cell uptake, subcellular localization, and oxidative mechanisms can also be influenced by the crystal structure [287]. For example, a comparison of two polymorphous structures of $\mathrm { T i O } _ { 2 }$ NPs showed that one causes DNA damage through oxidation but not the other [290]. The nanoparticle’s surface properties can also contribute to their toxic effects through translocation and oxidation processes [291,292]. Table 8 summarizes the risk of toxicity of different nanoparticles.

![](images/fe389641461e2b688e81b944cb7251e364787533badf118e5361945dd0ecd46e.jpg)  
sed by exposure to nanoparticles and entrances of nanoscale materials intoFigure 13. Disease caused by exposure to nanoparticles and entrances of nanoscale materials into alation, dermal exposure, and ingestion, resulting in many potential hazards. the body through inhalation, dermal exposure, and ingestion, resulting in many potential hazards. ender. Image created by Biorender.

Table 8. Nanoparticles, their toxicity mechanisms and applications.   

<html><body><table><tr><td>Nanoparticle Type</td><td>Toxicity Mechanism</td><td>Applications</td><td>Refs</td></tr><tr><td>Aluminum oxide nanoparticles</td><td></td><td>Pomes</td><td>[290-293]</td></tr><tr><td>Gold nanoparticles</td><td>Non-toxic spherical core,relatively safe; lipid peroxidation,autophagy in lung fibroblasts</td><td>Contrast agents and drug carriers</td><td>[294,295]</td></tr><tr><td>Copper oxide nanoparticles</td><td>Oxidative damage (stress),cytotoxicity (cell membrane integrity),nephrotoxicity, genotoxicity, hepatotoxicity,and spleen toxicity</td><td>Antibacterial, semiconductors, heat transfer fluids,and contraceptive devices</td><td>[296-299]</td></tr><tr><td>Silver nanoparticles</td><td>Oxidative stress, genotoxicity,cell viability decrease, nephrotoxicity,cell membrane integrity lung toxicity,and cardiovascular toxicity</td><td>Wound dressing, prostheses, coating for surgical instruments, and antibacterial agents</td><td>[300-303]</td></tr><tr><td>Zinc oxide nanoparticles</td><td>Mitochondrial dysfunction,genotoxicity,oxidative stress,hepatotoxicity,cell membrane integrity, cell viability,cardiovascular toxicity,inflammation, neurotoxicity,cytotoxicityndreactiveen species production</td><td>Sunscreens,gas filters, UV detectors,wave filters,and body care products</td><td>[303-306]</td></tr><tr><td>Iron oxide nanoparticles</td><td>Neurotoxicity, mitochondrial function alterations, genotoxicity,lung toxicity, hepatotoxicity,rctive oxygen species production, cell viability,and endothelial permeability</td><td>Diagnostic agents and drug carriers</td><td>[307-309]</td></tr><tr><td>Titanium nanoparticles</td><td>Reactive oxygen species production, impotcitt toxicity,and cardiovascular toxicity</td><td>Coloring and pigment agents</td><td>[303,304]</td></tr><tr><td>Carbon-based nanoparticles and fullerenes</td><td>Cell membrane integrity,cell viability, bone epigenetic toxicity, skin toxicity,carcinogenesis, neurotoxicity,and immunotoxicity</td><td>Drug carriers</td><td>[310-313]</td></tr><tr><td>Polymeric nanoparticles</td><td></td><td>Drug carriers</td><td>[314,315]</td></tr><tr><td>Nickel oxide nanoparticles</td><td>Apoptosis and lipid peroxidation increase</td><td>Antiatrilifa</td><td>[316-320]</td></tr><tr><td>Cerium oxide nanoparticles</td><td>Apptss</td><td></td><td>[321-324]</td></tr></table></body></html>

# 10. Global Market and Future of Nanomaterials

Nanotechnology has evolved as a solution to many unsolved fundamental biological problems in the field of medicine, healthcare, and human life. This technology helps in the identification of various pathogens, toxins, pesticides, imaging of cancers, and also helps in the transport of active medicaments to the target sites effectively. Currently, many research institutes are involved in nanosystem research. Some of the outcomes of these studies are approved by internal nanotechnology organizations (e.g., the National Center for Nanoscience and Technology and the U.S. Food and Drug Administration) and are commercialized for their better applications in the fields mentioned above, and some of them are in the investigational stage. The biomedical application segment led the market and accounted for the largest revenue share of around $2 9 . 9 8 \%$ in 2020. The global nanomaterials market is expected to reach USD 57,608.26 million by 2026, growing at a CAGR of $1 9 . 8 6 \%$ during the forecast period (2021–2026). This growth is attributed to the wide range of applications of nanomaterials in the biomedical sector, including imaging, targeted drug delivery, nanorobots for surgery, nanodiagnostics, cell repair, and nanobiosensors [1–4].

The importance of nanotechnology and nanosciences open a wider scope for new biomedical-based applications using newly discovered nanomaterials. However, this growth in the use of nanomaterials will be limited by several challenges, including: (1) the ability to deliver cost-effective production of nanomaterials in large volumes; (2) defined production techniques that can be scaled up sufficiently to cover the cost required for targeting volume markets; (3) the rapid identification of priorities in nanoresearch to guarantee nanotechnologies’ and nanomaterial’s safety in the future; (4) address the gaps for current research in risk/toxicity/safety assessment for nanomaterials; and (5) develop an international standard for nanomaterial’s safety; to assist in the determination of appropriate risk management of nanomaterials [325–327].

The new and future innovation is nanomaterials that have exceptionally extraordinary properties in the food source chain (enhancement of food texture and quality, bioavailability, nutrient values, nano-pesticides, nano-fertilizers, and nano-herbicides) in the world agricultural sector. A large proportion of nanomedicines fail to meet such criteria, and as a result, they are not available in the pharmaceutical sector. Additionally, the scale-up and reproducibility of nanomedicines will be a future issue in formulation development. In the coming decade, nanomaterials will create a new history in the medical field by advancing new nanomaterials for their sustainable development. Synthesis of newer nanomaterials in the near future will revolutionize the treatment strategies for many diseases. There is a lot to achieve in the future in nanomaterial research for their extensive applications in various fields, such as biomedicine (bioimaging, biosensor), agriculture, environmental protection, and food processing.

# 11. Conclusions

Nanomaterials are interesting materials because of their superior and tunable physical, chemical, and biological features compared with bulk materials. Nanomaterials can be classified in function of their size, shape, composition, and origin. Researchers have exploited nanomaterial features by grafting different groups on them, thus making nanoparticles suitable for biomedical applications. In this review, we presented the applications of nanomaterials in bioimaging, skincare, tissue-engineered scaffolds, drug delivery systems, biosensors, and wound healing, as well as in the food and agricultural industries. The use of nanomaterials for targeted drug delivery has also dramatically progressed with exceptional applications to reduce the limitations of conventional drug delivery systems. Different nanomaterial types (e.g., spherical nanoparticles, core-shell, nanorods, nanowires, hollow, nanofibers, and mesoporous) are studied for the targeted delivery of drugs. Encapsulation techniques have also been tested to deliver various bioactive cytotoxic agents. Nanoparticles also have their place in tissue reengineering for the repair of various tissues. Thanks to their larger surface-area-to-volume ratio, nanostructured scaffolds can act as selective substrates to absorb specific proteins and promote cell adhesion. Carbon and metal-based nanoparticles for biosensor development can lead to many applications in agriculture and in the biomedical sector. The review also presented the fluorescence nanoparticles and the in vivo and in vitro fate of nanoparticles. The applications of fluorescence nanomaterials in bioimaging were explained clearly. The antimicrobial activities of various nanomaterials and their advantages and disadvantages are also discussed individually.

Author Contributions: Conceptualization, A.B.Y., and A.B.; methodology, V.H., D.T., M.G., A.B.Y., S.S., M.B. and A.B.; software, A.B.; investigation, V.H., D.T., M.G., A.B.Y., S.S., M.B. and A.B.; resources, V.H., D.T., M.G., A.B.Y., S.S., M.B. and A.B.; data curation, V.H., D.T., M.G., A.B.Y., S.S., M.B. and A.B.; writing—original draft preparation, V.H., D.T., M.G., A.B.Y., S.S., M.B. and A.B., writing— review and editing, V.H., D.T., M.G., A.B.Y., S.S., M.B. and A.B.; supervision, A.B.Y. and A.B.; project administration, A.B.Y. and A.B.; funding acquisition, A.B.Y. and A.B. All authors have read and agreed to the published version of the manuscript.

Funding: Ahmed Barhoum (NanoStruc Research Group, Helwan University, Project PIs) Egypt– France Joint Driver (Imhotep, Project No. 43990SF, 2020–2022), Joint Egyptian Japanese Scientific Cooperation (JEJSC, Project No. 42811, 2021–2022), and Irish Research Council (Project ID: GOIPD/2020/340) for financial support. Awadh Bihari Yadav would like to thank the Science and Engineering Research Board (SERB) and Nano mission, Department of Science and Technology (DST), Ministry of Science and Technology, India, for financial support (grant number CRG/2018/002135 and SR/NM/NS-1470/2014).

Institutional Review Board Statement: Not Applicable.

Informed Consent Statement: Not Applicable.

Data Availability Statement: The data presented in this study are available on request from the corresponding author.

Conflicts of Interest: Authors declare there is no conflict of interest.

# References

1. Gaur, M.; Misra, C.; Yadav, A.B.; Swaroop, S.; Maolmhuaidh, F.; Bechelany, M.; Barhoum, A. Biomedical Applications of Carbon Nanomaterials: Fullerenes, Quantum Dots, Nanotubes, Nanofibers, and Graphene. Materials 2021, 14, 5978. [CrossRef] [PubMed]   
2. Barhoum, A.; Pal, K.; Rahier, H.; Uludag, H.; Kim, I.S.; Bechelany, M. Nanofibers as new-generation materials: From spinning and nano-spinning fabrication techniques to emerging applications. Appl. Mater. Today 2019, 17, 1–35. [CrossRef]   
3. Jeevanandam, J.; Barhoum, A.; Chan, Y.S.; Dufresne, A.; Danquah, M.K. Review on nanoparticles and nanostructured materials: History, sources, toxicity and regulations. Beilstein J. Nanotechnol. 2018, 9, 1050–1074. [CrossRef]   
4. Barhoum, A.; El-Maghrabi, H.H.; Nada, A.A.; Sayegh, S.; Roualdes, S.; Renard, A.; Iatsunskyi, I.; Coy, E.; Bechelany, M. Simultaneous hydrogen and oxygen evolution reactions using free-standing nitrogen-doped-carbon–Co/CoOx nanofiber electrodes decorated with palladium nanoparticles. J. Mater. Chem. A 2021, 9, 17724–17739. [CrossRef]   
5. Prasad, S.; Kumar, V.; Kirubanandam, S.; Barhoum, A. Engineered nanomaterials: Nanofabrication and surface functionalization. In Emerging Applications of Nanoparticles and Architecture Nanostructures: Current Prospects and Future Trends; Elsevier Inc.: Amsterdam, The Netherlands, 2018; pp. 305–340. [CrossRef]   
6. Cremers, V.; Rampelberg, G.; Barhoum, A.; Walters, P.; Claes, N.; de Oliveira, T.M.; Van Assche, G.; Bals, S.; Dendooven, J.; Detavernier, C. Oxidation barrier of Cu and Fe powder by Atomic Layer Deposition. Surf. Coat. Technol. 2018, 349, 1032–1041. [CrossRef]   
7. Hammani, S.; Moulai-Mostefa, N.; Samyn, P.; Bechelany, M.; Dufresne, A.; Barhoum, A. Morphology, Rheology and Crystallization in Relation to the Viscosity Ratio of Polystyrene/Polypropylene Polymer Blends. Materials 2020, 13, 926. [CrossRef]   
8. Barhoum, A.; Van Lokeren, L.; Rahier, H.; Dufresne, A.; Van Assche, G. Roles of in situ surface modification in controlling the growth and crystallization of ${ \mathrm { C a C O } } _ { 3 }$ nanoparticles, and their dispersion in polymeric materials. J. Mater. Sci. 2015, 50, 7908–7918. [CrossRef]   
9. Rehan, M.; Barhoum, A.; Khattab, T.; Gätjen, L.; Wilken, R. Colored, photocatalytic, antimicrobial and UV-protected viscose fibers decorated with $\mathrm { A g / A g _ { 2 } C O _ { 3 } }$ and $\mathrm { A g / A g _ { 3 } P O _ { 4 } }$ nanoparticles. Cellulose 2019, 26, 5437–5453. [CrossRef]   
10. Abdel-Haleem, F.M.; Salah, A.; Rizk, M.S.; Moustafa, H.; Bechelany, M.; Barhoum, A. Carbon-based Nanosensors for Salicylate Determination in Pharmaceutical Preparations. Electroanalysis 2019, 31, 778–789. [CrossRef]   
11. Abdel-Haleem, F.; Mahmoud, S.; Abdel-Ghani, N.; El Nashar, R.; Bechelany, M.; Barhoum, A. Polyvinyl Chloride Modified Carbon Paste Electrodes for Sensitive Determination of Levofloxacin Drug in Serum, Urine, and Pharmaceutical Formulations. Sensors 2021, 21, 3150. [CrossRef]   
12. Abdel-Haleem, F.M.; Gamal, E.; Rizk, M.S.; Madbouly, A.; El Nashar, R.M.; Anis, B.; Elnabawy, H.M.; Khalil, A.S.G.; Barhoum, A. Molecularly Imprinted Electrochemical Sensor-Based $\mathrm { F e } _ { 2 } \mathrm { O } _ { 3 } @ \mathrm { I }$ MWCNTs for Ivabradine Drug Determination in Pharmaceutical Formulation, Serum, and Urine Samples. Front. Bioeng. Biotechnol. 2021, 9, 648704. [CrossRef] [PubMed]   
13. Parikha Mehrotra, Biosensors and their applications—A review. J. Oral Biol. Craniofac. Res. 2016, 6, 153–159. [CrossRef] [PubMed]   
14. Rasouli, R.; Barhoum, A.; Uludag, H. A review of nanostructured surfaces and materials for dental implants: Surface coating, patterning and functionalization for improved performance. Biomater. Sci. 2018, 6, 1312–1338. [CrossRef] [PubMed]   
15. Rasouli, R.; Barhoum, A.; Bechelany, M.; Dufresne, A. Nanofibers for Biomedical and Healthcare Applications. Macromol. Biosci. 2018, 19, e1800256. [CrossRef]   
16. Singh, K.R.; Nayak, V.; Singh, J.; Singh, A.K.; Singh, R.P. Potentialities of bioinspired metal and metal oxide nanoparticles in biomedical sciences. RSC Adv. 2021, 11, 24722–24746. [CrossRef]   
17. Tan, K.X.; Barhoum, A.; Pan, S.; Danquah, M.K. Risks and toxicity of nanoparticles and nanostructured materials. In Emerging Applications of Nanoparticles and Architecture Nanostructures: Current Prospects and Future Trends; Elsevier Inc.: Amsterdam, The Netherlands, 2018; pp. 121–139. [CrossRef]   
18. Kim, D.; Kim, J.; Park, Y.I.; Lee, N.; Hyeon, T. Recent Development of Inorganic Nanoparticles for Biomedical Imaging. ACS Central Sci. 2018, 4, 324–336. [CrossRef]   
19. Mihai, M.M.; Dima, M.B.; Dima, B.; Holban, A.M. Nanomaterials for Wound Healing and Infection Control. Materials 2019, 12, 2176. [CrossRef]   
20. Said, M.M.; Rehan, M.; El-Sheikh, S.M.; Zahran, M.K.; Abdel-Aziz, M.S.; Bechelany, M.; Barhoum, A. Multifunctional Hydroxyapatite/Silver Nanoparticles/Cotton Gauze for Antimicrobial and Biomedical Applications. Nanomaterials 2021, 11, 429. [CrossRef]   
21. Kumar, S.; Bhushan, P.; Bhattacharya, S. Fabrication of Nanostructures with Bottom-up Approach and Their Utility in Diagnostics, Therapeutics, and Others. In Environmental, Chemical and Medical Sensors; Springer: Berlin/Heidelberg, Germany, 2017; pp. 167–198. [CrossRef]   
22. Sawy, A.M.; Barhoumbb, A.; Gaber, S.A.A.; El-Hallouty, S.M.; Shousha, W.G.; Maarouf, A.A.; Khalilaf, S.G.A. Insights of doxorubicin loaded graphene quantum dots: Synthesis, DFT drug interactions, and cytotoxicity. Mater. Sci. Eng. C 2021, 122, 111921. [CrossRef]   
23. Barhoum, A.; Van Assche, G.; Rahier, H.; Fleisch, M.; Bals, S.; Delplancked, M.-P.; Leroux, F.; Bahnemann, D. Sol-gel hot injection synthesis of ZnO nanoparticles into a porous silica matrix and reaction mechanism. Mater. Des. 2017, 119, 270–276. [CrossRef]   
24. Barhoum, A.; Melcher, J.; Van Assche, G.; Rahier, H.; Bechelany, M.; Fleisch, M.; Bahnemann, D. Synthesis, growth mechanism, and photocatalytic activity of Zinc oxide nanostructures: Porous microparticles versus nonporous nanoparticles. J. Mater. Sci. 2016, 52, 2746–2762. [CrossRef]   
25. Hong, G.; Antaris, A.L.; Dai, H. Near-infrared fluorophores for biomedical imaging. Nat. Biomed. Eng. 2017, 1, 10. [CrossRef]   
26. Malik, N.; Arfin, T.; Khan, A.U. Graphene nanomaterials: Chemistry and pharmaceutical perspectives. In Nanomaterials for Drug Delivery and Therapy; Grumezescu, T., Ed.; Elsevier Inc.: Amsterdam, The Netherlands, 2019; pp. 373–402. [CrossRef]   
27. Yang, Y.; Wang, L.; Wan, B.; Gu, Y.; Li, X. Optically Active Nanomaterials for Bioimaging and Targeted Therapy. Front. Bioeng. Biotechnol. 2019, 7, 320. [CrossRef] [PubMed]   
28. Su, S.; Kang, P.M. Systemic Review of Biodegradable Nanomaterials in Nanomedicine. Nanomaterials 2020, 10, 656. [CrossRef]   
29. Siafaka, P.I.; Okur, N.Ü.; Karantas, I.D.; Okur, M.E.; Gündo ˘gdu, E.A. Current update on nanoplatforms as therapeutic and diagnostic tools: A review for the materials used as nanotheranostics and imaging modalities. Asian J. Pharm. Health Sci. 2021, 16, 24–46. [CrossRef]   
30. Yoon, H.Y.; Jeon, S.; You, D.G.; Park, J.H.; Kwon, I.C.; Koo, H.; Kim, K. Inorganic Nanoparticles for Image-Guided Therapy. Bioconjug. Chem. 2017, 28, 124–134. [CrossRef]   
31. Snipstad, S.; Hak, S.; Baghirov, H.; Sulheim, E.; Mørch, Y.; Lélu, S.; Von Haartman, E.; Bäck, M.; Nilsson, K.P.R.; Klymchenko, A.S.; et al. Labeling nanoparticles: Dye leakage and altered cellular uptake. Cytom. Part A 2016, 91, 760–766. [CrossRef]   
32. Shandilya, P.; Sambyal, S.; Sharma, R.; Mandyal, P.; Fang, B. Properties, optimized morphologies, and advanced strategies for photocatalytic applications of ${ \cal W } { \cal O } _ { 3 }$ based photocatalysts. J. Hazard. Mater. 2022, 428, 128218. [CrossRef]   
33. Rees, P.; Wills, J.W.; Brown, R.; Barnes, C.M.; Summers, H.D. The origin of heterogeneous nanoparticle uptake by cells. Nat. Commun. 2019, 10, 2341. [CrossRef]   
34. Sukhanova, A.; Bozrova, S.; Sokolov, P.; Berestovoy, M.; Karaulov, A.; Nabiev, I. Dependence of Nanoparticle Toxicity on Their Physical and Chemical Properties. Nanoscale Res. Lett. 2018, 13, 44. [CrossRef]   
35. Forest, V.; Pourchez, J. Preferential binding of positive nanoparticles on cell membranes is due to electrostatic interactions: A too simplistic explanation that does not take into account the nanoparticle protein corona. Mater. Sci. Eng. C 2017, 70, 889–896. [CrossRef] [PubMed]   
36. Foroozandeh, P.; Aziz, A.A. Insight into Cellular Uptake and Intracellular Trafficking of Nanoparticles. Nanoscale Res. Lett. 2018, 13, 339. [CrossRef] [PubMed]   
37. Friedman, A.D.; Claypool, S.E.; Liu, R. The Smart Targeting of Nanoparticles. Curr. Pharm. Des. 2013, 19, 6315–6329. [CrossRef] [PubMed]   
38. Yoo, J.; Park, C.; Yi, G.; Lee, D.; Koo, H. Active Targeting Strategies Using Biological Ligands for Nanoparticle Drug Delivery Systems. Cancers 2019, 11, 640. [CrossRef]   
39. Spicer, C.D.; Jumeaux, C.; Gupta, B.; Stevens, M.M. Peptide and protein nanoparticle conjugates: Versatile platforms for biomedical applications. Chem. Soc. Rev. 2018, 47, 3574–3620. [CrossRef]   
40. Kher, G.; Trehan, S.; Misra, A. Antisense Oligonucleotides and RNA Interference. In Challenges in Delivery of Therapeutic Genomics and Proteomics; Elsevier: Amsterdam, The Netherlands, 2011; pp. 325–386. [CrossRef]   
41. Cremers, G.A.O.; Rosier, B.J.H.M.; Brillas, R.R.; Albertazzi, L.; de Greef, T.F.A. Efficient Small-Scale Conjugation of DNA to Primary Antibodies for Multiplexed Cellular Targeting. Bioconjug. Chem. 2019, 30, 2384–2392. [CrossRef]   
42. Gao, J.; Yao, X.; Chen, Y.; Gao, Z.; Zhang, J. Near-Infrared Light-Induced Self-Powered Aptasensing Platform for Aflatoxin B1 Based on Upconversion Nanoparticles-Doped ${ \mathrm { B i } } _ { 2 } { \mathrm { S } } _ { 3 }$ Nanorods. Anal. Chem. 2020, 93, 677–682. [CrossRef]   
43. Yu, Z.; Eich, C.; Cruz, L.J. Recent Advances in Rare-Earth-Doped Nanoparticles for NIR-II Imaging and Cancer Theranostics. Front. Chem. 2020, 8, 496. [CrossRef]   
44. Chinnathambi, S.; Shirahata, N. Recent advances on fluorescent biomarkers of near-infrared quantum dots for in vitro and in vivo imaging. Sci. Technol. Adv. Mater. 2019, 20, 337–355. [CrossRef]   
45. Arvizo, R.; Bhattacharya, R.; Mukherjee, P. Gold nanoparticles: Opportunities and challenges in nanomedicine. Expert Opin. Drug Deliv. 2010, 7, 753–763. [CrossRef]   
46. Dong, H.; Sun, L.-D.; Yan, C.-H. Lanthanide-Doped Upconversion Nanoparticles for Super-Resolution Microscopy. Front. Chem. 2021, 8, 619377. [CrossRef] [PubMed]   
47. El-Sheikh, S.M.; Barhoum, A.; El-Sherbiny, S.; Morsy, F.; El-Midany, A.A.-H.; Rahier, H. Preparation of superhydrophobic nanocalcite crystals using Box–Behnken design. Arab. J. Chem. 2019, 12, 1479–1486. [CrossRef]   
48. Rehan, M.; Khattab, T.A.; Barohum, A.; Gätjen, L.; Wilken, R. Development of $\mathrm { A g / A g X }$ $( \mathrm { X } = \mathrm { C l } ,$ I) nanoparticles toward antimicrobial, UV-protected and self-cleanable viscose fibers. Carbohydr. Polym. 2018, 197, 227–236. [CrossRef] [PubMed]   
49. Wahajuddin; Arora, S. Superparamagnetic iron oxide nanoparticles: Magnetic nanoplatforms as drug carriers. Int. J. Nanomed. 2012, 7, 3445–3471. [CrossRef]   
50. Lim, W.Q.; Phua, S.Z.F.; Xu, H.V.; Sreejith, S.; Zhao, Y. Recent advances in multifunctional silica-based hybrid nanocarriers for bioimaging and cancer therapy. Nanoscale 2015, 8, 12510–12519. [CrossRef] [PubMed]   
51. Liang, R.; Wei, M.; Evans, D.G.; Duan, X. Inorganic nanomaterials for bioimaging, targeted drug delivery and therapeutics. Chem. Commun. 2014, 50, 14071–14081. [CrossRef] [PubMed]   
52. Bhunia, S.K.; Saha, A.; Maity, A.; Ray, S.C.; Jana, N.R. Carbon Nanoparticle-based Fluorescent Bioimaging Probes. Sci. Rep. 2013, 3, srep01473. [CrossRef] [PubMed]   
53. Karatutlu, A.; Barhoum, A.; Sapelkin, A. Theories of nanoparticle and nanostructure formation in liquid phase. In Emerging Applications of Nanoparticles and Architecture Nanostructures: Current Prospects and Future Trends; Elsevier Inc.: Amsterdam, The Netherlands, 2018; pp. 597–619. [CrossRef]   
54. Barhoum, A.; García-Betancourt, M.L. Physicochemical characterization of nanomaterials: Size, morphology, optical, magnetic, and electrical properties. In Emerging Applications of Nanoparticles and Architecture Nanostructures: Current Prospects and Future Trends; Elsevier Inc.: Amsterdam, The Netherlands, 2018; pp. 279–304. [CrossRef]   
55. Karatutlu, A.; Barhoum, A.; Sapelkin, A. Liquid-phase synthesis of nanoparticles and nanostructured materials. In Emerging Applications of Nanoparticles and Architecture Nanostructures: Current Prospects and Future Trends; Elsevier Inc.: Amsterdam, The Netherlands, 2018; pp. 1–28. [CrossRef]   
56. Tian, P.; Tang, L.; Teng, K.; Lau, S. Graphene quantum dots from chemistry to applications. Mater. Today Chem. 2018, 10, 221–258. [CrossRef]   
57. Singh, I.; Arora, R.; Dhiman, H.; Pahwa, R. Carbon Quantum Dots: Synthesis, Characterization and Biomedical Applications. Turk. J. Pharm. Sci. 2018, 15, 219–230. [CrossRef]   
58. Jhonsi, M.A. Carbon Quantum Dots for Bioimaging. In State of the Art in Nano-Bioimaging; IntechOpen: London, UK, 2018. [CrossRef]   
59. Ravichandiran, P.; Subramaniyan, S.A.; Bella, A.P.; Johnson, P.M.; Kim, A.R.; Shim, K.S.; Yoo, D.J. Simple Fluorescence Turn-On Chemosensor for Selective Detection of $\mathtt { B a } ^ { 2 + }$ Ion and Its Live Cell Imaging. Anal. Chem. 2019, 91, 10095–10101. [CrossRef]   
60. Hubbs, A.F.; Sargent, L.M.; Porter, D.W.; Sager, T.M.; Chen, B.T.; Frazer, D.G.; Castranova, V.; Sriram, K.; Nurkiewicz, T.R.; Reynolds, S.H.; et al. Nanotechnology: Toxicologic Pathology. Toxicol. Pathol. 2013, 41, 395–409. [CrossRef] [PubMed]   
61. Maldiney, T.; Richard, C.; Seguin, J.; Wattier, N.; Bessodes, M.; Scherman, D. Effect of Core Diameter, Surface Coating, and PEG Chain Length on the Biodistribution of Persistent Luminescence Nanoparticles in Mice. ACS Nano 2011, 5, 854–862. [CrossRef] [PubMed]   
62. Heeger, A.J. Semiconducting and Metallic Polymers: The Fourth Generation of Polymeric Materials (Nobel Lecture). Angew. Chemie Int. Ed. 2001, 40, 2591–2611. [CrossRef]   
63. Thomas, S.W.; Joly, G.D.; Swager, T.M. Chemical Sensors Based on Amplifying Fluorescent Conjugated Polymers. Chem. Rev. 2007, 107, 1339–1386. [CrossRef]   
64. Feng, X.; Liu, L.; Wang, S.; Zhu, D. Water-soluble fluorescent conjugated polymers and their interactions with biomacromolecules for sensitive biosensors. Chem. Soc. Rev. 2010, 39, 2411–2419. [CrossRef]   
65. Khanbeigi, R.A.; Abelha, T.F.; Woods, A.; Rastoin, O.; Harvey, R.D.; Jones, M.-C.; Forbes, B.; Green, M.A.; Collins, H.; Dailey, L.A. Surface Chemistry of Photoluminescent F8BT Conjugated Polymer Nanoparticles Determines Protein Corona Formation and Internalization by Phagocytic Cells. Biomacromolecules 2015, 16, 733–742. [CrossRef]   
66. Tuncel, D.; Demir, H.V. Conjugated polymer nanoparticles. Nanoscale 2010, 2, 484–494. [CrossRef]   
67. Du, T.; Zhao, C.; Lai, L.; Luo, S.; Selke, M.; Rehman, F.U.; Li, X.; Sun, Y.; Jiang, H.; Wang, X. Rapid and multimodal in vivo bioimaging of cancer cells through in situ biosynthesis of Zn&Fe nanoclusters. Nano Res. 2017, 10, 2626–2632. [CrossRef]   
68. Feng, L.; Liu, L.; Lv, F.; Bazan, G.C.; Wang, S. Preparation and Biofunctionalization of Multicolor Conjugated Polymer Nanoparticles for Imaging and Detection of Tumor Cells. Adv. Mater. 2014, 26, 3926–3930. [CrossRef]   
69. Ravichandiran, P.; Prabakaran, D.; Maroli, N.; Kim, A.R.; Park, B.-H.; Han, M.-K.; Ramesh, T.; Ponpandian, S.; Yoo, D.J. Mitochondria-targeted acridine-based dual-channel fluorescence chemosensor for detection of $\mathrm { S n ^ { 4 + } }$ and $\mathrm { C r } _ { 2 } \mathrm { O } _ { 7 2 }$ -ions in water and its application in discriminative detection of cancer cells. J. Hazard. Mater. 2021, 419, 126409. [CrossRef]   
70. Rhim, W.-K.; Kim, M.; Hartman, K.L.; Kang, K.W.; Nam, J.-M. Radionuclide-labeled nanostructures for In Vivo imaging of cancer. Nano Converg. 2015, 2, 10. [CrossRef]   
71. Xu, Y.; Wang, C.; Jiang, T.; Ran, G.; Song, Q. Cadmium induced aggregation of orange–red emissive carbon dots with enhanced fluorescence for intracellular imaging. J. Hazard. Mater. 2021, 427, 128092. [CrossRef] [PubMed]   
72. Zhao, W.; Yu, X.; Peng, S.; Luo, Y.; Li, J.; Lu, L. Construction of nanomaterials as contrast agents or probes for glioma imaging. J. Nanobiotechnol. 2021, 19, 1–31. [CrossRef] [PubMed]   
73. Pratiwi, F.; Kuo, C.W.; Chen, B.-C.; Chen, P. Recent advances in the use of fluorescent nanoparticles for bioimaging. Nanomedicine 2019, 14, 1759–1769. [CrossRef]   
74. Chen, S.; Wang, H.; Hong, Y.; Tang, B.Z. Fabrication of fluorescent nanoparticles based on AIE luminogens (AIE dots) and their applications in bioimaging. Mater. Horizons 2016, 3, 283–293. [CrossRef]   
75. Caponetti, V.; Trzcinski, J.W.; Cantelli, A.; Tavano, R.; Papini, E.; Mancin, F.; Montalti, M. Self-Assembled Biocompatible Fluorescent Nanoparticles for Bioimaging. Front. Chem. 2019, 7, 168. [CrossRef]   
76. Lin, J.; Chen, X.; Huang, P. Graphene-based nanomaterials for bioimaging. Adv. Drug Deliv. Rev. 2016, 105, 242–254. [CrossRef]   
77. Yadav, V.; Roy, S.; Singh, P.; Khan, Z.; Jaiswal, A. 2D ${ \bf M o S } _ { 2 }$ -Based Nanomaterials for Therapeutic, Bioimaging, and Biosensing Applications. Small 2018, 15, e1803706. [CrossRef]   
78. Zhao, W.; Li, A.; Zhang, A.; Zheng, Y.; Liu, J. Recent Advances in Functional-Polymer-Decorated Transition-Metal Nanomaterials for Bioimaging and Cancer Therapy. ChemMedChem 2018, 13, 2134–2149. [CrossRef]   
79. Yi, Z.; Luo, Z.; Qin, X.; Chen, Q.; Liu, X. Lanthanide-Activated Nanoparticles: A Toolbox for Bioimaging, Therapeutics, and Neuromodulation. Accounts Chem. Res. 2020, 53, 2692–2704. [CrossRef]   
80. Xu, Y.; Li, P.; Cheng, D.; Wu, C.; Lu, Q.; Yang, W.; Zhu, X.; Yin, P.; Liu, M.; Li, H.; et al. Group IV nanodots: Synthesis, surface engineering and application in bioimaging and biotherapy. J. Mater. Chem. B 2020, 8, 10290–10308. [CrossRef] [PubMed]   
81. Esmaeili, Y.; Bidram, E.; Zarrabi, A.; Amini, A.; Cheng, C. Graphene oxide and its derivatives as promising in-vitro bio-imaging platforms. Sci. Rep. 2020, 10, 18052. [CrossRef] [PubMed]   
82. Das, A.K.; Gavel, P.K. Low molecular weight self-assembling peptide-based materials for cell culture, antimicrobial, antiinflammatory, wound healing, anticancer, drug delivery, bioimaging and 3D bioprinting applications. Soft Matter 2020, 16, 10065–10095. [CrossRef] [PubMed]   
83. Tan, P.; Li, H.; Wang, J.; Gopinath, S.C. Silver nanoparticle in biosensor and bioimaging: Clinical perspectives. Biotechnol. Appl. Biochem. 2021, 68, 1236–1242. [CrossRef] [PubMed]   
84. Bao, C.; Beziere, N.; del Pino, P.; Pelaz, B.; Estrada, G.; Tian, F.; Ntziachristos, V.; de la Fuente, J.M.; Cui, D. Gold Nanoprisms as Optoacoustic Signal Nanoamplifiers for In Vivo Bioimaging of Gastrointestinal Cancers. Small 2012, 9, 68–74. [CrossRef] [PubMed]   
85. Chen, N.-T.; Tang, K.-C.; Chung, M.-F.; Cheng, S.-H.; Huang, C.-M.; Chu, C.-H.; Chou, P.-T.; Souris, J.S.; Chen, C.-T.; Mou, C.-Y.; et al. Enhanced Plasmonic Resonance Energy Transfer in Mesoporous Silica-Encased Gold Nanorod for Two-PhotonActivated Photodynamic Therapy. Theranostics 2014, 4, 798–807. [CrossRef]   
86. Yadav, A.; Rao, C.; Verma, N.C.; Mishra, P.M.; Nandi, C.K. Magnetofluorescent Nanoprobe for Multimodal and Multicolor Bioimaging. Mol. Imaging 2020, 19, 1–8. [CrossRef]   
87. Klymchenko, A.S.; Liu, F.; Collot, M.; Anton, N. Dye-Loaded Nanoemulsions: Biomimetic Fluorescent Nanocarriers for Bioimaging and Nanomedicine. Adv. Health Mater. 2020, 10, e2001289. [CrossRef]   
88. Xu, Y.-M.; Tan, H.W.; Zheng, W.; Liang, Z.-L.; Yu, F.-Y.; Wu, D.-D.; Yao, Y.; Zhong, Q.-H.; Yan, R.; Lau, A.T.Y. Cadmium telluride quantum dot-exposed human bronchial epithelial cells: A further study of the cellular response by proteomics. Toxicol. Res. 2019, 8, 994–1001. [CrossRef]   
89. Patra, J.K.; Das, G.; Fraceto, L.F.; Campos, E.V.R.; del Pilar Rodriguez-Torres, M.; Acosta-Torres, L.S.; Diaz-Torres, L.A.; Grillo, R.; Swamy, M.K.; Sharma, S.; et al. Nano based drug delivery systems: Recent developments and future prospects. J. Nanobiotechnol. 2018, 16, 71. [CrossRef]   
90. Yao, Y.; Zhou, Y.; Liu, L.; Xu, Y.; Chen, Q.; Wang, Y.; Wu, S.; Deng, Y.; Zhang, J.; Shao, A. Nanoparticle-Based Drug Delivery in Cancer Therapy and Its Role in Overcoming Drug Resistance. Front. Mol. Biosci. 2020, 7, 193. [CrossRef] [PubMed]   
91. Kim, B.; Shin, J.; Wu, J.; Omstead, D.T.; Kiziltepe, T.; Littlepage, L.E.; Bilgicer, B. Engineering peptide-targeted liposomal nanoparticles optimized for improved selectivity for HER2-positive breast cancer cells to achieve enhanced in vivo efficacy. J. Control. Release 2020, 322, 530–541. [CrossRef] [PubMed]   
92. Deng, Y.; Zhang, X.; Shen, H.; He, Q.; Wu, Z.; Liao, W.; Yuan, M. Application of the Nano-Drug Delivery System in Treatment of Cardiovascular Diseases. Front. Bioeng. Biotechnol. 2020, 7, 489. [CrossRef] [PubMed]   
93. Deng, S.; Gigliobianco, M.R.; Censi, R.; Di Martino, P. Polymeric Nanocapsules as Nanotechnological Alternative for Drug Delivery System: Current Status, Challenges and Opportunities. Nanomaterials 2020, 10, 847. [CrossRef]   
94. du Toit, L.; Pillay, V.; Choonara, Y.; Pillay, S.; Harilall, S.-L. Patenting of Nanopharmaceuticals in Drug Delivery: No Small Issue. Recent Patents Drug Deliv. Formul. 2007, 1, 131–142. [CrossRef]   
95. Narducci, D. An Introduction to Nanotechnologies: What’s in it for Us? Veter-Res. Commun. 2007, 31, 131–137. [CrossRef]   
96. Navya, P.; Kaphle, A.; Srinivas, S.; Bhargava, S.K.; Rotello, V.M.; Daima, H.K. Current trends and challenges in cancer management and therapy using designer nanomaterials. Nano Converg. 2019, 6, 1–30. [CrossRef]   
97. Wen, H.; Jung, H.; Li, X. Drug Delivery Approaches in Addressing Clinical Pharmacology-Related Issues: Opportunities and Challenges. AAPS J. 2015, 17, 1327–1340. [CrossRef]   
98. Debnath, S.K.; Srivastava, R. Drug Delivery with Carbon-Based Nanomaterials as Versatile Nanocarriers: Progress and Prospects. Front. Nanotechnol. 2021, 3, 15. [CrossRef]   
99. Marcelo, G.; Kaplan, E.; Tarazona, M.P.; Mendicuti, F. Interaction of gold nanoparticles with Doxorubicin mediated by supramolecular chemistry. Colloids Surf. B Biointerfaces 2015, 128, 237–244. [CrossRef]   
100. Zhang, Y.; Walker, J.B.; Minic, Z.; Liu, F.; Goshgarian, H.; Mao, G. Transporter protein and drug-conjugated gold nanoparticles capable of bypassing the blood-brain barrier. Sci. Rep. 2016, 6, 25794. [CrossRef] [PubMed]   
101. Muhammad, Z.; Raza, A.; Ghafoor, S.; Naeem, A.; Naz, S.S.; Riaz, S.; Ahmed, W.; Rana, N.F. PEG capped methotrexate silver nanoparticles for efficient anticancer activity and biocompatibility. Eur. J. Pharm. Sci. 2016, 91, 251–255. [CrossRef] [PubMed]   
102. Prabha, G.; Raj, V. Sodium alginate–polyvinyl alcohol–bovin serum albumin coated $\mathrm { F e } _ { 3 } \mathrm { O } _ { 4 }$ nanoparticles as anticancer drug delivery vehicle: Doxorubicin loading and in vitro release study and cytotoxicity to HepG2 and L02 cells. Mater. Sci. Eng. C 2017, 79, 410–422. [CrossRef] [PubMed]   
103. Prabha, G.; Raj, V. Formation and characterization of $\beta$ -cyclodextrin ( $\beta$ -CD)-polyethyleneglycol (PEG)-polyethyleneimine (PEI) coated $\mathrm { F e } _ { 3 } \mathrm { O } _ { 4 }$ nanoparticles for loading and releasing 5-Fluorouracil drug. Biomed. Pharmacother. 2016, 80, 173–182. [CrossRef] [PubMed]   
104. Luo, X.; Matranga, C.; Tan, S.; Alba, N.; Cui, X.T. Carbon nanotube nanoreservior for controlled release of anti-inflammatory dexamethasone. Biomaterials 2011, 32, 6316–6323. [CrossRef] [PubMed]   
105. Bhirde, A.A.; Patel, S.; Sousa, A.A.; Patel, V.; Molinolo, A.A.; Ji, Y.; Leapman, R.D.; Gutkind, J.S.; Rusling, J.F. Distribution and clearance of PEG-single-walled carbon nanotube cancer drug delivery vehicles in mice. Nanomedicine 2010, 5, 1535–1546. [CrossRef] [PubMed]   
106. Ruzycka, M.; Kowalik, P.; Kowalczyk, A.; Bujak, P.; Nowicka, A.; Wojewódzka, M.; Kruszewski, M.; Grudzinski, I. Quantum dots as targeted doxorubicin drug delivery nanosystems in human lung cancer cells. Cancer Nanotechnol. 2021, 12, 8. [CrossRef]   
107. Roozbahani, M.; Kharaziha, M.; Emadi, R. pH sensitive dexamethasone encapsulated laponite nanoplatelets: Release mechanism and cytotoxicity. Int. J. Pharm. 2017, 518, 312–319. [CrossRef]   
108. Gurdag, S.; Khandare, J.; Stapels, S.; Matherly, L.H.; Kannan, R.M. Activity of Dendrimer−Methotrexate Conjugates on Methotrexate-Sensitive and -Resistant Cell Lines. Bioconjug. Chem. 2006, 17, 275–283. [CrossRef]   
109. Cirstoiu-Hapca, A.; Buchegger, F.; Lange, N.; Bossy, L.; Gurny, R.; Delie, F. Benefit of anti-HER2-coated paclitaxel-loaded immunonanoparticles in the treatment of disseminated ovarian cancer: Therapeutic efficacy and biodistribution in mice. J. Control. Release 2010, 144, 324–331. [CrossRef]   
110. Wilson, B.; Samanta, M.K.; Santhi, K.; Kumar, K.S.; Ramasamy, M.; Suresh, B. Chitosan nanoparticles as a new delivery system for the anti-Alzheimer drug tacrine. Nanomed. NanotechnoL. Biol. Med. 2010, 6, 144–152. [CrossRef] [PubMed]   
111. Anderson, R.; Franch, A.; Castell, M.; Perez-Cano, F.J.; Bräuer, R.; Pohlers, D.; Gajda, M.; Siskos, A.P.; Katsila, T.; Tamvakopoulos, C.; et al. Liposomal encapsulation enhances and prolongs the anti-inflammatory effects of water-soluble dexamethasone phosphate in experimental adjuvant arthritis. Arthritis Res. Ther. 2010, 12, R147. [CrossRef] [PubMed]   
112. Zalba, S.; Contreras-Sandoval, A.; Haeri, A.; Hagen, T.L.T.; Navarro-Blasco, I.; Koning, G.; Garrido, M.J. Cetuximab-oxaliplatinliposomes for epidermal growth factor receptor targeted chemotherapy of colorectal cancer. J. Control. Release 2015, 210, 26–38. [CrossRef] [PubMed]   
113. Zhang, Z.; Wu, Y.; Kuang, G.; Liu, S.; Zhou, D.; Chen, X.; Jing, X.; Huang, Y. Pt(iv) prodrug-backboned micelle and DCA loaded nanofibers for enhanced local cancer treatment. J. Mater. Chem. B 2017, 5, 2115–2125. [CrossRef] [PubMed]   
114. Liu, S.; Zhou, G.; Liu, D.; Xie, Z.; Huang, Y.; Wang, X.; Wu, W.; Jing, X. Inhibition of orthotopic secondary hepatic carcinoma in mice by doxorubicin-loaded electrospun polylactide nanofibers. J. Mater. Chem. B 2012, 1, 101–109. [CrossRef]   
115. Adeel, M.; Duzagac, F.; Canzonieri, V.; Rizzolio, F. Self-Therapeutic Nanomaterials for Cancer Therapy: A Review. ACS Appl. Nano Mater. 2020, 3, 4962–4971. [CrossRef]   
116. Sutradhar, K.B.; Amin, L. Nanotechnology in Cancer Drug Delivery and Selective Targeting. ISRN Nanotechnol. 2014, 2014, 1–12. [CrossRef]   
117. Senapati, S.; Mahanta, A.K.; Kumar, S.; Maiti, P. Controlled drug delivery vehicles for cancer treatment and their performance. Signal Transduct. Target. Ther. 2018, 3, 7. [CrossRef]   
118. Farokhzad, O.C.; Langer, R. Impact of Nanotechnology on Drug Delivery. ACS Nano 2009, 3, 16–20. [CrossRef]   
119. Gong, Y.-K.; Winnik, F.M. Strategies in biomimetic surface engineering of nanoparticles for biomedical applications. Nanoscale 2011, 4, 360–368. [CrossRef]   
120. Khan, I.; Saeed, K.; Khan, I. Nanoparticles: Properties, applications and toxicities. Arab. J. Chem. 2019, 12, 908–931. [CrossRef]   
121. Zhu, Y.; Liao, L. Applications of Nanoparticles for Anticancer Drug Delivery: A Review. J. Nanosci. Nanotechnol. 2015, 15, 4753–4773. [CrossRef]   
122. Wen, R.; Umeano, A.C.; Kou, Y.; Xu, J.; Farooqi, A.A. Nanoparticle systems for cancer vaccine. Nanomedicine 2019, 14, 627–648. [CrossRef] [PubMed]   
123. James, H.P.; John, R.; Alex, A.; Anoop, K. Smart polymers for the controlled delivery of drugs—A concise overview. Acta Pharm. Sin. B 2014, 4, 120–127. [CrossRef] [PubMed]   
124. Fleige, E.; Quadir, M.A.; Haag, R. Stimuli-responsive polymeric nanocarriers for the controlled transport of active compounds: Concepts and applications. Adv. Drug Deliv. Rev. 2012, 64, 866–884. [CrossRef]   
125. Cohen, B.E.; Bangham, A.D. Diffusion of Small Non-Electrolytes across Liposome Membranes. Nature 1972, 236, 173–174. [CrossRef]   
126. Thanou, M. Nanoparticles for Drug and Gene Delivery. In Encyclopedia of Biophysics; Springer: Berlin/Heidelberg, Germany, 2013; pp. 1686–1691. [CrossRef]   
127. Vahed, S.Z.; Fathi, N.; Samiei, M.; Dizaj, S.M.; Sharifi, S. Targeted cancer drug delivery with aptamer-functionalized polymeric nanoparticles. J. Drug Target. 2018, 27, 292–299. [CrossRef]   
128. Gugulothu, D.; Barhoum, A.; Afzal, S.M.; Venkateshwarlu, B.; Uludag, H. Structural Multifunctional Nanofibers and their Emerging Applications. In Handbook of Nanofibers; Springer Nature Switzerland AG: Cham, Switzerland, 2018; pp. 1–41. [CrossRef]   
129. Bubakir, M.M.; Li, H.; Barhoum, A.; Yang, W. Advances in Melt Electrospinning Technique. In Handbook of Nanofibers; Springer International Publishing: Cham, Switzerland, 2019; pp. 125–156. [CrossRef]   
130. Sasikala, A.R.K.; Unnithan, A.R.; Yun, Y.-H.; Park, C.H.; Kim, C.S. An implantable smart magnetic nanofiber device for endoscopic hyperthermia treatment and tumor-triggered controlled drug release. Acta Biomater. 2016, 31, 122–133. [CrossRef]   
131. Kim, Y.-J.; Ebara, M.; Aoyagi, T. A Smart Hyperthermia Nanofiber with Switchable Drug Release for Inducing Cancer Apoptosis. Adv. Funct. Mater. 2013, 23, 5753–5761. [CrossRef]   
132. Ankegowda, V.M.; Kollur, S.P.; Prasad, S.K.; Pradeep, S.; Dhramashekara, C.; Jain, A.S.; Prasad, A.; Srinivasa, C.; Sridhara Setty, P.; Gopinath, S.M.; et al. Phyto-Mediated Synthesis of Silver Nanoparticles Using Terminalia chebula Fruit Extract and Evaluation of Its Cytotoxic and Antimicrobial Potential. Molecules 2020, 25, 5042. [CrossRef]   
133. Gagliardi, A.; Cosco, D.; Udongo, B.P.; Dini, L.; Viglietto, G.; Paolino, D. Design and Characterization of Glyceryl MonooleateNanostructures Containing Doxorubicin Hydrochloride. Pharmaceutics 2020, 12, 1017. [CrossRef] [PubMed]   
134. Faisalina, A.; Sonvico, F.; Colombo, P.; Amirul, A.; Wahab, H.; Majid, M. Docetaxel-Loaded Poly(3HB-co-4HB) Biodegradable Nanoparticles: Impact of Copolymer Composition. Nanomaterials 2020, 10, 2123. [CrossRef]   
135. Nicosia, A.; Cavallaro, G.; Costa, S.; Utzeri, M.A.; Cuttitta, A.; Giammona, G.; Mauro, N. Carbon Nanodots for On Demand Chemophotothermal Therapy Combination to Elicit Necroptosis: Overcoming Apoptosis Resistance in Breast Cancer Cell Lines. Cancers 2020, 12, 3114. [CrossRef] [PubMed]   
136. Sui, J.; He, M.; Yang, Y.; Ma, M.; Guo, Z.; Zhao, M.; Liang, J.; Sun, Y.; Fan, Y.; Zhang, X. Reversing P-Glycoprotein-Associated Multidrug Resistance of Breast Cancer by Targeted Acid-Cleavable Polysaccharide Nanoparticles with Lapatinib Sensitization. ACS Appl. Mater. Interfaces 2020, 12, 51198–51211. [CrossRef] [PubMed]   
137. Tieu, T.; Wojnilowicz, M.; Huda, P.; Thurecht, K.J.; Thissen, H.; Voelcker, N.H.; Cifuentes-Rius, A. Nanobody-displaying porous silicon nanoparticles for the co-delivery of siRNA and doxorubicin. Biomater. Sci. 2020, 9, 133–147. [CrossRef] [PubMed]   
138. Dorjsuren, B.; Chaurasiya, B.; Ye, Z.; Liu, Y.; Li, W.; Wang, C.; Shi, D.; Evans, C.E.; Webster, T.J.; Shen, Y. Cetuximab-Coated Thermo-Sensitive Liposomes Loaded with Magnetic Nanoparticles and Doxorubicin for Targeted EGFR-Expressing Breast Cancer Combined Therapy. Int. J. Nanomed. 2020, 15, 8201–8215. [CrossRef] [PubMed]   
139. Chu, I.-M.; Tseng, S.-H.; Chou, M.-Y. Cetuximab-conjugated iron oxide nanoparticles for cancer imaging and therapy. Int. J. Nanomed. 2015, 10, 3663–3685. [CrossRef]   
140. Fernandes, C.; Oliveira, C.; Benfeito, S.; Soares, P.; Garrido, J.; Borges, F. Nanotechnology and antioxidant therapy: An emerging approach for neurodegenerative diseases. Curr. Med. Chem. 2014, 21, 4311–4327. [CrossRef]   
141. Martinelli, C.; Pucci, C.; Battaglini, M.; Marino, A.; Ciofani, G. Antioxidants and Nanotechnology: Promises and Limits of Potentially Disruptive Approaches in the Treatment of Central Nervous System Diseases. Adv. Health Mater. 2019, 9, e1901589. [CrossRef]   
142. Swain, S.; Sahu, P.K.; Beg, S.; Babu, S.M. Nanoparticles for Cancer Targeting: Current and Future Directions. Curr. Drug Deliv. 2016, 13, 1290–1302. [CrossRef]   
143. Vaiserman, A.; Koliada, A.; Zayachkivska, A.; Lushchak, O. Nanodelivery of Natural Antioxidants: An Anti-aging Perspective. Front. Bioeng. Biotechnol. 2020, 7, 447. [CrossRef] [PubMed]   
144. Shah, S.T.; Yehya, W.A.; Saad, O.; Simarani, K.; Chowdhury, Z.; Alhadi, A.A.; Al-Ani, L.A. Surface Functionalization of Iron Oxide Nanoparticles with Gallic Acid as Potential Antioxidant and Antimicrobial Agents. Nanomaterials 2017, 7, 306. [CrossRef] [PubMed]   
145. Verma, A.K. Anti-oxidant activities of biopolymeric nanoparticles: Boon or bane. J. Pharm. Res. 2014, 8, 871.   
146. Sharpe, E.; Andreescu, D.; Andreescu, S. Artificial Nanoparticle Antioxidants. In Oxidative Stress: Diagnostics, Prevention, and Therapy; ACS Publications: Washington, DC, USA, 2011; pp. 235–253. [CrossRef]   
147. Yusof, F.; Ismail, N. Antioxidants effects of Platinum Nanoparticles: A Potential Alternative Treatment to Lung Diseases. J. Appl. Pharm. Sci. 2015, 5, 140–145. [CrossRef]   
148. Watanabe, A.; Kajita, M.; Kim, J.; Kanayama, A.; Takahashi, K.; Mashino, T.; Miyamoto, Y. In vitro free radical scavenging activity of platinum nanoparticles. Nanotechnology 2009, 20, 455105. [CrossRef]   
149. Patlolla, A.K.; Hackett, D.; Tchounwou, P.B. Genotoxicity study of silver nanoparticles in bone marrow cells of Sprague–Dawley rats. Food Chem. Toxicol. 2015, 85, 52–60. [CrossRef]   
150. Saikia, J.P.; Paul, S.; Konwar, B.K.; Samdarshi, S.K. Nickel oxide nanoparticles: A novel antioxidant. Colloids Surf. B Biointerfaces 2010, 78, 146–148. [CrossRef]   
151. Keshari, A.K.; Srivastava, R.; Singh, P.; Yadav, V.B.; Nath, G. Antioxidant and antibacterial activity of silver nanoparticles synthesized by Cestrum nocturnum. J. Ayurveda Integr. Med. 2018, 11, 37–44. [CrossRef]   
152. Kumar, H.; Bhardwaj, K.; Nepovimova, E.; Kuca, K.; Dhanjal, D.S.; Bhardwaj, S.; Bhatia, S.K.; Verma, R.; Kumar, D. Antioxidant Functionalized Nanoparticles: A Combat against Oxidative Stress. Nanomaterials 2020, 10, 1334. [CrossRef]   
153. Khan, M.S.; Vishakante, G.D.; Siddaramaiah, H. Gold nanoparticles: A paradigm shift in biomedical applications. Adv. Colloid Interface Sci. 2013, 199–200, 44–58. [CrossRef]   
154. Khalil, I.; Yehye, W.A.; Etxeberria, A.E.; Alhadi, A.A.; Dezfooli, S.M.; Julkapli, N.B.M.; Basirun, W.J.; Seyfoddin, A. Nanoantioxidants: Recent Trends in Antioxidant Delivery Applications. Antioxidants 2019, 9, 24. [CrossRef] [PubMed]   
155. Arriagada, F.; Günther, G.; Morales, J. Nanoantioxidant–Based Silica Particles as Flavonoid Carrier for Drug Delivery Applications. Pharmaceutics 2020, 12, 302. [CrossRef] [PubMed]   
156. Yi, X.; Zimmerman, M.C.; Yang, R.; Tong, J.; Vinogradov, S.; Kabanov, A.V. Pluronic-modified superoxide dismutase 1 attenuates angiotensin II-induced increase in intracellular superoxide in neurons. Free. Radic. Biol. Med. 2010, 49, 548–558. [CrossRef] [PubMed]   
157. Tong, J.; Yi, X.; Luxenhofer, R.; Banks, W.A.; Jordan, R.; Zimmerman, M.C.; Kabanov, A.V. Conjugates of Superoxide Dismutase 1 with Amphiphilic Poly(2-oxazoline) Block Copolymers for Enhanced Brain Delivery: Synthesis, Characterization and Evaluation in Vitro and in Vivo. Mol. Pharm. 2012, 10, 360–377. [CrossRef] [PubMed]   
158. Christofidou-Solomidou, M.; Scherpereel, A.; Wiewrodt, R.; Ng, K.; Sweitzer, T.; Arguiri, E.; Shuvaev, V.; Solomides, C.C.; Albelda, S.M.; Muzykantov, V.R. PECAM-directed delivery of catalase to endothelium protects against pulmonary vascular oxidative stress. Am. J. Physiol. Cell. Mol. Physiol. 2003, 285, L283–L292. [CrossRef]   
159. Brynskikh, A.M.; Zhao, Y.; Mosley, R.L.; Li, S.; Boska, M.D.; Klyachko, N.L.; Kabanov, A.V.; Gendelman, H.E.; Batrakova, E.V. Macrophage delivery of therapeutic nanozymes in a murine model of Parkinson’s disease. Nanomedicine 2010, 5, 379–396. [CrossRef]   
160. Williams, S.R.; Lepene, B.S.; Thatcher, C.D.; Long, T.E. Synthesis and Characterization of Poly(ethylene glycol)−Glutathione Conjugate Self-Assembled Nanoparticles for Antioxidant Delivery. Biomacromolecules 2008, 10, 155–161. [CrossRef]   
161. Gonnet, M.; Lethuaut, L.; Boury, F. New trends in encapsulation of liposoluble vitamins. J. Control Release 2010, 146, 276–290. [CrossRef]   
162. Wegmann, J.; Krucker, M.; Bachmann, S.; Fischer, G.; Zeeb, D.; Lienau, A.; Glaser, T.; Runge, F.; Lüddecke, E.; Albert, K. Characterization of Lycopene Nanoparticles Combining Solid-State and Suspended-State NMR Spectroscopy. J. Agric. Food Chem. 2002, 50, 7510–7514. [CrossRef]   
163. Mignet, N.; Seguin, J.; Romano, M.R.; Brullé, L.; Touil, Y.; Scherman, D.; Bessodes, M.; Chabot, G.G. Development of a liposomal formulation of the natural flavonoid fisetin. Int. J. Pharm. 2012, 423, 69–76. [CrossRef]   
164. Deligiannakis, Y.; Sotiriou, G.A.; Pratsinis, S.E. Antioxidant and Antiradical $\mathrm { S i O } _ { 2 }$ Nanoparticles Covalently Functionalized with Gallic Acid. ACS Appl. Mater. Interfaces 2012, 4, 6609–6617. [CrossRef] [PubMed]   
165. Liu, P.; Tang, H.; Lu, M.; Gao, C.; Wang, F.; Ding, Y.; Zhang, S.; Yang, M. Preparation of nanosilica-immobilized antioxidant and the antioxidative behavior in low density polyethylene. Polym. Degrad. Stab. 2016, 135, 1–7. [CrossRef]   
166. Du, L.; Suo, S.; Wang, G.; Jia, H.; Liu, K.J.; Zhao, B.; Liu, Y. Mechanism and Cellular Kinetic Studies of the Enhancement of An-tioxidant Activity by Using Surface-Functionalized Gold Nanoparticles. Chem. Eur. J. 2013, 19, 1281–1287. [CrossRef] [PubMed]   
167. Sahiner, N.; Sagbas, S.; Aktas, N. Preparation and characterization of monodisperse, mesoporous natural poly (tannic acid)–silica nanoparticle composites with antioxidant properties. Microporous Mesoporous Mater. 2016, 226, 316–324. [CrossRef]   
168. Arriagada, F.; Correa, O.; Gunther, G.; Nonell, S.; Mura, F.; Olea-Azar, C.; Morales, J. Morin Flavonoid Adsorbed on Mesoporous Silica, a Novel Antioxidant Nanomaterial. PLoS ONE 2016, 11, e0164507. [CrossRef] [PubMed]   
169. Kang, D.-W.; Kim, C.K.; Jeong, H.-G.; Soh, M.; Kim, T.; Choi, I.-Y.; Ki, S.-K.; Kim, D.Y.; Yang, W.; Hyeon, T.; et al. Biocompatible custom ceria nanoparticles against reactive oxygen species resolve acute inflammatory reaction after intracerebral hemorrhage. Nano Res. 2017, 10, 2743–2760. [CrossRef]   
170. Joseph, A.; Wood, T.; Chen, C.-C.; Corry, K.; Snyder, J.M.; Juul, S.E.; Parikh, P.; Nance, E. Curcumin-loaded polymeric nanoparticles for neuroprotection in neonatal rats with hypoxic-ischemic encephalopathy. Nano Res. 2018, 11, 5670–5688. [CrossRef]   
171. Yalcinkaya, F.; Komarek, M.; Lubasová, D.; Sanetrnik, F.; Maryska, J. Preparation of Antibacterial Nanofibre/Nanoparticle Covered Composite Yarns. J. Nanomater. 2016, 2016, 7565972. [CrossRef]   
172. Salama, A.; Abouzeid, R.; Leong, W.S.; Jeevanandam, J.; Samyn, P.; Dufresne, A.; Bechelany, M.; Barhoum, A. NanocelluloseBased Materials for Water Treatment: Adsorption, Photocatalytic Degradation, Disinfection, Antifouling, and Nanofiltration. Nanomaterials 2021, 11, 3008. [CrossRef]   
173. Shahriary, M.; Veisi, H.; Hekmati, M.; Hemmati, S. In situ green synthesis of Ag nanoparticles on herbal tea extract (Stachys lavandulifolia)-modified magnetic iron oxide nanoparticles as antibacterial agent and their 4-nitrophenol catalytic reduction activity. Mater. Sci. Eng. C 2018, 90, 57–66. [CrossRef]   
174. Youssef, A.M.; Moustafa, H.A.; Barhoum, A.; Hakim, A.E.-F.A.A.; Dufresne, A. Evaluation of the Morphological, Electrical and Antibacterial Properties of Polyaniline Nanocomposite Based on Zn/Al-Layered Double Hydroxides. ChemistrySelect 2017, 2, 8553–8566. [CrossRef]   
175. Sudha, P.N.; Sangeetha, K.; Vijayalakshmi, K.; Barhoum, A. Nanomaterials History, Classification, Unique Properties, Production and Market. In Emerging Applications of Nanoparticles and Architecture Nanostructures: Current Prospects and Future Trends; Elsevier Inc.: Amsterdam, The Netherlands, 2018; ISBN 9780128135167.   
176. Nnaji, C.O.; Jeevanandam, J.; Chan, Y.S.; Danquah, M.K.; Pan, S.; Barhoum, A. Engineered nanomaterials for wastewater treatment: Current and future trends. In Fundamentals of Nanoparticles; Elsevier Inc.: Amsterdam, The Netherlands, 2018; pp. 129–168. [CrossRef]   
177. Jung, W.K.; Koo, H.C.; Kim, K.W.; Shin, S.; Kim, S.H.; Park, Y.H. Antibacterial Activity and Mechanism of Action of the Silver Ion in Staphylococcus aureus and Escherichia coli. Appl. Environ. Microbiol. 2008, 74, 2171–2178. [CrossRef]   
178. Smetana, A.B.; Klabunde, K.J.; Marchin, G.R.; Sorensen, C.M. Biocidal Activity of Nanocrystalline Silver Powders and Particles. Langmuir 2008, 24, 7457–7464. [CrossRef] [PubMed]   
179. Panacek, A.; Kvitek, L.; Prucek, R.; Kolar, M.; Vecerova, R.; Pizurova, N.; Sharma, V.K.; Nevecna, T.; Zboril, R. Silver colloid nanoparticles: Synthesis, characterization, and their antibacterial activity. J. Phys. Chem. B 2006, 110, 16248–16253. [CrossRef] [PubMed]   
180. Nanda, A.; Saravanan, M. Biosynthesis of silver nanoparticles from Staphylococcus aureus and its antimicrobial activity against MRSA and MRSE. Nanomed. Nanotechnol. Biol. Med. 2009, 5, 452–456. [CrossRef] [PubMed]   
181. Matsunaga, T.; Tomoda, R.; Nakajima, T.; Nakamura, N.; Komine, T. Continuous-sterilization system that uses photosemiconductor powders. Appl. Environ. Microbiol. 1988, 54, 1330–1333. [CrossRef]   
182. Kim, B.; Kim, D.; Cho, D.; Cho, S. Bactericidal effect of $\mathrm { T i O } _ { 2 }$ photocatalyst on selected food-borne pathogenic bacteria. Chemosphere 2003, 52, 277–281. [CrossRef]   
183. Sunada, K.; Kikuchi, Y.; Hashimoto, K.; Fujishima, A. Bactericidal and Detoxification Effects of $\mathrm { T i O } _ { 2 }$ Thin Film Photocatalysts. Environ. Sci. Technol. 1998, 32, 726–728. [CrossRef]   
184. Ren, G.; Hu, D.; Cheng, E.W.; Vargas-Reus, M.A.; Reip, P.; Allaker, R.P. Characterisation of copper oxide nanoparticles for antimicrobial applications. Int. J. Antimicrob. Agents 2009, 33, 587–590. [CrossRef]   
185. Cioffi, N.; Torsi, L.; Ditaranto, N.; Tantillo, G.; Ghibelli, L.; Sabbatini, L.; Bleve-Zacheo, T.; D’Alessio, M.; Zambonin, A.P.G.; Traversa, E. Copper Nanoparticle/Polymer Composites with Antifungal and Bacteriostatic Properties. Chem. Mater. 2005, 17, 5255–5262. [CrossRef]   
186. Rajakumar, G.; Rahuman, A.A.; Roopan, S.M.; Khanna, V.G.; Elango, G.; Kamaraj, C.; Zahir, A.A.; Velayutham, K. Fungusmediated biosynthesis and characterization of $\mathrm { T i O } _ { 2 }$ nanoparticles and their activity against pathogenic bacteria. Spectrochim. Acta Part A Mol. Biomol. Spectrosc. 2012, 91, 23–29. [CrossRef] [PubMed]   
187. Gómez-Ortíz, N.; De la Rosa-García, S.; González-Gómez, W.; Soria-Castro, M.; Quintana, P.; Oskam, G.; Ortega-Morales, B. Antifungal Coatings Based on $\mathrm { C a ( O H ) } _ { 2 }$ Mixed with $Z _ { \mathrm { n O } } / \mathrm { T i O } _ { 2 }$ Nanomaterials for Protection of Limestone Monuments. ACS Appl. Mater. Interfaces 2013, 5, 1556–1565. [CrossRef] [PubMed]   
188. Herman, A.; Herman, A.P. Nanoparticles as Antimicrobial Agents: Their Toxicity and Mechanisms of Action. J. Nanosci. Nanotechnol. 2014, 14, 946–957. [CrossRef] [PubMed]   
189. Mageshwari, K.; Sathyamoorthy, R. Flower-shaped CuO Nanostructures: Synthesis, Characterization and Antimicrobial Activity. J. Mater. Sci. Technol. 2013, 29, 909–914. [CrossRef]   
190. Panáˇcek, A.; Koláˇr, M.; Veˇceˇrová, R.; Prucek, R.; Soukupová, J.; Kryštof, V.; Hamal, P.; Zboˇril, R.; Kvítek, L. Antifungal activity of silver nanoparticles against Candida spp. Biomaterials 2009, 30, 6333–6340. [CrossRef]   
191. Sawai, J.; Yoshikawa, T. Quantitative evaluation of antifungal activity of metallic oxide powders (MgO, CaO and ZnO) by an indirect conductimetric assay. J. Appl. Microbiol. 2004, 96, 803–809. [CrossRef]   
192. Sawai, J.; Yoshikawa, T. Measurement of fungi by an indirect conductimetric assay. Lett. Appl. Microbiol. 2003, 37, 40–44. [CrossRef] [PubMed]   
193. Di Gianvincenzo, P.; Marradi, M.; Martínez-Ávila, O.M.; Bedoya, L.M.; Alcami, J.; Penadés, S. Gold nanoparticles capped with sulfate-ended ligands as anti-HIV agents. Bioorg. Med. Chem. Lett. 2010, 20, 2718–2721. [CrossRef]   
194. Lara, H.H.; Ayala-Nuñez, N.V.; Ixtepan-Turrent, L.; Rodriguez-Padilla, C. Mode of antiviral action of silver nanoparticles against HIV-1. J. Nanobiotechnol. 2010, 8, 1. [CrossRef] [PubMed]   
195. Lu, L.; Sun, R.W.-Y.; Chen, R.; Hui, C.-K.; Ho, C.-M.; Luk, J.M.; Lau, G.K.K.; Che, C.-M. Silver nanoparticles inhibit hepatitis B virus replication. Antivir. Ther. 2008, 13, 253–262. [CrossRef]   
196. Zheng, Y.; Cloutier, P.; Hunting, D.J.; Sanche, L. Radiosensitization by Gold Nanoparticles: Comparison of DNA Damage Induced by Low and High-Energy Electrons. J. Biomed. Nanotechnol. 2008, 4, 469–473. [CrossRef]   
197. Syngouna, V.I.; Chrysikopoulos, C.V. Inactivation of MS2 bacteriophage by titanium dioxide nanoparticles in the presence of quartz sand with and without ambient light. J. Colloid Interface Sci. 2017, 497, 117–125. [CrossRef] [PubMed]   
198. Cui, H.; Jiang, J.; Gu, W.; Sun, C.; Wu, D.; Yang, T.; Yang, G. Photocatalytic Inactivation Efficiency of Anatase Nano- $\cdot \mathrm { T i O } _ { 2 }$ Sol on the H9N2 Avian Influenza Virus. Photochem. Photobiol. 2010, 86, 1135–1139. [CrossRef] [PubMed]   
199. Baiocco, P.; Ilari, A.; Ceci, P.; Orsini, S.; Gramiccia, M.; Di Muccio, T.; Colotti, G. Inhibitory Effect of Silver Nanoparticles on Trypanothione Reductase Activity and Leishmania infantum Proliferation. ACS Med. Chem. Lett. 2010, 2, 230–233. [CrossRef]   
200. Allahverdiyev, A.M.; Abamor, E.; Bagirova, M.; Ustundag, C.B.; Kaya, C.; Rafailovich, M. Antileishmanial effect of silver nanoparticles and their enhanced antiparasitic activity under ultraviolet light. Int. J. Nanomed. 2011, 6, 2705–2714. [CrossRef]   
201. Nadhman, A.; Nazir, S.; Khan, M.I.; Arooj, S.; Bakhtiar, M.; Shahnaz, G.; Yasinzai, M. PEGylated silver doped zinc oxide nanoparticles as novel photosensitizers for photodynamic therapy against Leishmania. Free. Radic. Biol. Med. 2014, 77, 230–238.   
202. Saad, A.H.A.; Soliman, M.I.; Azzam, A.M. Antiparasitic Activity of Silver and Copper Oxide Nanoparticles against Entamoeba histolytica and Cryptosporidium parvum Cysts. J. Egypt. Soc. Parasitol. 2015, 45, 593–602. [CrossRef]   
203. Ramyadevi, J.; Jeyasubramanian, K.; Marikani, A.; Rajakumar, G.; Rahuman, A.A.; Santhoshkumar, T.; Kirthi, A.V.; Jayaseelan, C.; Marimuthu, S. Copper nanoparticles synthesized by polyol process used to control hematophagous parasites. Parasitol. Res. 2011, 109, 1403–1415. [CrossRef]   
204. Barhoum, A.; Rehan, M.F.; Rahier, H.; Bechelany, M.; Van Assche, G. Seed-Mediated Hot-Injection Synthesis of Tiny Ag Nanocrystals on Nanoscale Solid Supports and Reaction Mechanism. ACS Appl. Mater. Interfaces 2016, 8, 10551–10561. [CrossRef]   
205. Rehan, M.; Barhoum, A.; Van Assche, G.; Dufresne, A.; Gätjen, L.; Wilken, R. Towards multifunctional cellulosic fabric: UV photo-reduction and in-situ synthesis of silver nanoparticles into cellulose fabrics. Int. J. Biol. Macromol. 2017, 98, 877–886. [CrossRef]   
206. Barhoum, A.; Rahier, H.; Benelmekki, M.; Van Assche, G. Recent trends in nanostructured particles: Synthesis, functionalization, and applications. In Fundamentals of Nanoparticles; Elsevier Inc.: Amsterdam, The Netherlands, 2018; pp. 605–639. [CrossRef]   
207. Rastogi, A.; Singh, P.; Haraz, F.A.; Barhoum, A. Chapter 19—Biological Synthesis of Nanoparticles: An Environmentally Benign Approach. Available online: https://www.sciencedirect.com/science/article/pii/B9780323512558000239 (accessed on 21 April 2019).   
208. Dakal, T.C.; Kumar, A.; Majumdar, R.S.; Yadav, V. Mechanistic Basis of Antimicrobial Actions of Silver Nanoparticles. Front. Microbiol. 2016, 7, 1831. [CrossRef] [PubMed]   
209. Möhler, J.S.; Sim, W.; Blaskovich, M.A.; Cooper, M.A.; Ziora, Z.M. Silver bullets: A new lustre on an old antimicrobial agent. Biotechnol. Adv. 2018, 36, 1391–1411. [CrossRef] [PubMed]   
210. Gupta, N.; Upadhyaya, C.P.; Singh, A.; Abd-Elsalam, K.A.; Prasad, R. Applications of Silver Nanoparticles in Plant Protection. In Nanobiotechnology Applications in Plant Protection; Springer: Berlin/Heidelberg, Germany, 2018; pp. 247–265. [CrossRef]   
211. Abdel-Aziz, M.; Shaheen, M.S.; El-Nekeety, A.A.; Abdel-Wahhab, M.A. Antioxidant and antibacterial activity of silver nanoparticles biosynthesized using Chenopodium murale leaf extract. J. Saudi Chem. Soc. 2013, 18, 356–363. [CrossRef]   
212. Belaiche, Y.; Khelef, A.; Laouini, S.E.; Bouafia, A.; Tedjani, M.L.; Barhoum, A. Green synthesis and characterization of silver/silver oxide nanoparticles using aqueous leaves extract of artemisia herbaalba as reducing and capping agents. Rom. J. Mater. 2021, 51, 342–352.   
213. Fatima, S.; Ali, K.; Ahmed, B.; Al Kheraif, A.A.; Syed, A.; Elgorban, A.M.; Musarrat, J.; Lee, J. Titanium Dioxide Nanoparticles Induce Inhibitory Effects against Planktonic Cells and Biofilms of Human Oral Cavity Isolates of Rothia mucilaginosa, Georgenia sp. and Staphylococcus saprophyticus. Pharmaceutics 2021, 13, 1564. [CrossRef]   
214. Al-Shabib, N.A.; Husain, F.M.; Qais, F.A.; Ahmad, N.; Khan, A.; Alyousef, A.A.; Arshad, M.; Noor, S.; Khan, J.M.; Alam, P.; et al. Phyto-Mediated Synthesis of Porous Titanium Dioxide Nanoparticles From Withania somnifera Root Extract: Broad-Spectrum Attenuation of Biofilm and Cytotoxic Properties Against HepG2 Cell Lines. Front. Microbiol. 2020, 11, 1680. [CrossRef]   
215. Ilyas, M.; Waris, A.; Khan, A.U.; Zamel, D.; Yar, L.; Baset, A.; Muhaymin, A.; Khan, S.; Ali, A.; Ahmad, A. Biological synthesis of titanium dioxide nanoparticles from plants and microorganisms and their potential biomedical applications. Inorg. Chem. Commun. 2021, 133, 108968. [CrossRef]   
216. Balaraman, R.P.; Mendel, J.; Flores, L.; Choudhary, M. Nanoparticle Biosynthesis and Interaction with the Microbial Cell, Antimicrobial and Antibiofilm Effects, and Environmental Impact. In Nanomaterial Biointeractions at the Cellular, Organismal and System Levels; Springer: Cham, Switzerland, 2021; pp. 371–405. [CrossRef]   
217. Jardón-Maximino, N.; Cadenas-Pliego, G.; Ávila-Orta, C.; Comparán-Padilla, V.; Lugo-Uribe, L.; Pérez-Alvarez, M.; Tavizón, S.; Santillán, G. Antimicrobial Property of Polypropylene Composites and Functionalized Copper Nanoparticles. Polymers 2021, 13, 1694. [CrossRef]   
218. Gharpure, S.; Akash, A.; Ankamwar, B. A Review on Antimicrobial Properties of Metal Nanoparticles. J. Nanosci. Nanotechnol. 2020, 20, 3303–3339. [CrossRef]   
219. El-Sheikh, S.; El-Sherbiny, S.; Barhoum, A.; Deng, Y. Effects of cationic surfactant during the precipitation of calcium carbonate nano-particles on their size, morphology, and other characteristics. Colloids Surf. A Physicochem. Eng. Asp. 2013, 422, 44–49. [CrossRef]   
220. Sharma, U.; Badyal, P.N.; Gupta, S. Polymeric nanoparticles drug delivery to brain: A review. Int. J. Pharmacol. 2015, 2, 60–69.   
221. Jun, A.S.; Larkin, D.F.P. Prospects for gene therapy in corneal disease. Eye 2003, 17, 906–911. [CrossRef] [PubMed]   
222. Dzau, V.J.; Mann, M.J.; Morishita, R.; Kaneda, Y. Fusigenic viral liposome for gene therapy in cardiovascular diseases. Proc. Natl. Acad. Sci. USA 1996, 93, 11421–11425. [CrossRef] [PubMed]   
223. Caplen, N.; Gao, X.; Hayes, P.; Elaswarapu, R.; Fisher, G.; Kinrade, E.; Chakera, A.; Schorr, J.; Hughes, B.; Dorin, J.R. Gene therapy for cystic fibrosis in humans by liposome-mediated DNA transfer: The production of resources and the regulatory process. Gene Ther. 1994, 1, 139–147. [PubMed]   
224. Balazs, D.A.; Godbey, W. Liposomes for Use in Gene Delivery. J. Drug Deliv. 2010, 2011, 326497. [CrossRef] [PubMed]   
225. Ito, I.; Ji, L.; Tanaka, F.; Saito, Y.; Gopalan, B.; Branch, C.D.; Xu, K.; Atkinson, E.N.; Bekele, B.N.; Stephens, L.C.; et al. Liposomal vector mediated delivery of the 3p FUS1 gene demonstrates potent antitumor activity against human lung cancer in vivo. Cancer Gene Ther. 2004, 11, 733–739. [CrossRef] [PubMed]   
226. Singh, B.N.; Prateeksha; Gupta, V.K.; Chen, J.; Atanasov, A. Organic Nanoparticle-Based Combinatory Approaches for Gene Therapy. Trends Biotechnol. 2017, 35, 1121–1124. [CrossRef] [PubMed]   
227. Chen, J.; Guo, Z.; Tian, H.; Chen, X. Production and clinical development of nanoparticles for gene delivery. Mol. Ther. Methods Clin. Dev. 2016, 3, 16023. [CrossRef]   
228. Nagamune, T. Biomolecular engineering for nanobio/bionanotechnology. Nano Converg. 2017, 4, 1–56. [CrossRef]   
229. Prabu, S.L.; Suriyaprakash, T.N.K.; Thirumurugan, R. Medicated Nanoparticle for Gene Delivery. In Advanced Technology for Delivering Therapeutics; IntechOpen: London, UK, 2017; Available online: https://www.intechopen.com/chapters/52818 (accessed on 11 May 2017). [CrossRef]   
230. Jat, S.K.; Bhattacharya, J.; Sharma, M.K. Nanomaterial based gene delivery: A promising method for plant genome engineering. J. Mater. Chem. B 2020, 8, 4165–4175. [CrossRef]   
231. Abdel-Haleem, F.M.; Gamal, E.; Rizk, M.S.; El Nashar, R.M.; Anis, B.; Elnabawy, H.M.; Khalil, A.S.; Barhoum, A. t-Butyl calixarene/ $\mathrm { F e } _ { 2 } \mathrm { O } _ { 3 }$ @MWCNTs composite-based potentiometric sensor for determination of ivabradine hydrochloride in pharmaceutical formulations. Mater. Sci. Eng. C 2020, 116, 111110. [CrossRef] [PubMed]   
232. Abdel-Haleem, F.M.; Saad, M.; Barhoum, A.; Bechelany, M.; Rizk, M.S. PVC membrane, coated-wire, and carbon-paste ionselective electrodes for potentiometric determination of galantamine hydrobromide in physiological fluids. Mater. Sci. Eng. C 2018, 89, 140–148. [CrossRef] [PubMed]   
233. El Nashar, R.M.; Ghani, N.T.A.; El Gohary, N.A.; Barhoum, A.; Madbouly, A. Molecularly imprinted polymers based biomimetic sensors for mosapride citrate detection in biological fluids. Mater. Sci. Eng. C 2017, 76, 123–129. [CrossRef] [PubMed]   
234. El-Beshlawy, M.M.; Abdel-Haleem, F.M.; Barhoum, A. Molecularly Imprinted Potentiometric Sensor for Nanomolar Determination of Pioglitazone Hydrochloride in Pharmaceutical Formulations. Electroanalysis 2021, 33, 1244–1254. [CrossRef]   
235. Naresh, V.; Lee, N. A Review on Biosensors and Recent Development of Nanostructured Materials-Enabled Biosensors. Sensors 2021, 21, 1109. [CrossRef]   
236. Abdel-Karim, R.; Reda, Y.; Abdel-Fattah, A. Review—Nanostructured Materials-Based Nanosensors. J. Electrochem. Soc. 2020, 167, 037554. [CrossRef]   
237. Tang, C.K.; Vaze, A.; Shen, M.; Rusling, J.F. High-Throughput Electrochemical Microfluidic Immunoarray for Multiplexed Detection of Cancer Biomarker Proteins. ACS Sens. 2016, 1, 1036–1043. [CrossRef]   
238. Wang, Z.; Hu, T.; Liang, R.; Wei, M. Application of Zero-Dimensional Nanomaterials in Biosensing. Front. Chem. 2020, 8, 320. [CrossRef]   
239. Cotta, M.A. Quantum Dots and Their Applications: What Lies Ahead? ACS Appl. Nano Mater. 2020, 3, 4920–4924. [CrossRef]   
240. Abraham, J.; Arunima, R.; Nimitha, K.; George, S.C.; Thomas, S. One-dimensional (1D) nanomaterials: Nanorods and nanowires. In Nanoscale Processing; Elsevier: Amsterdam, The Netherlands, 2021; pp. 71–101. [CrossRef]   
241. Erol, O.; Uyan, I.; Hatip, M.; Yilmaz, C.; Tekinay, A.B.; Guler, M.O. Recent advances in bioactive 1D and 2D carbon nanomaterials for biomedical applications. Nanomed. Nanotechnol. Biol. Med. 2017, 14, 2433–2454. [CrossRef]   
242. Dvir, T.; Timko, B.P.; Kohane, D.S.; Langer, R. Nanotechnological strategies for engineering complex tissues. Nat. Nanotechnol. 2011, 6, 13–22. [CrossRef] [PubMed]   
243. Shi, J.; Votruba, A.R.; Farokhzad, O.; Langer, R. Nanotechnology in Drug Delivery and Tissue Engineering: From Discovery to Applications. Nano Lett. 2010, 10, 3223–3230. [CrossRef] [PubMed]   
244. Zhang, K.; Barhoum, A.; Xiaoqing, C.; Li, H.; Samyn, P. Cellulose Nanofibers: Fabrication and Surface Functionalization Techniques. In Handbook of Nanofibers; Springer International Publishing: Cham, Switzerland, 2019; pp. 409–449. [CrossRef]   
245. Gugulothu, D.; Barhoum, A.; Nerella, R.; Ajmer, R.; Bechlany, M. Fabrication of Nanofibers: Electrospinning and NonElectrospinning Techniques. In Handbook of Nanofibers; Springer International Publishing: Cham, Switzerland, 2018; pp. 1–34. [CrossRef]   
246. Meftahi, A.; Samyn, P.; Geravand, S.A.; Khajavi, R.; Alibkhshi, S.; Bechelany, M.; Barhoum, A. Nanocelluloses as skin biocompatible materials for skincare, cosmetics, and healthcare: Formulations, regulations, and emerging applications. Carbohydr. Polym. 2021, 278, 118956. [CrossRef] [PubMed]   
247. Rabie, A.M.I.; Ali, A.S.M.; Al-Zeer, M.A.; Barhoum, A.; El-Hallouty, S.; Shousha, W.G.; Berg, J.; Kurreck, J.; Khalil, A.S.G. Spontaneous Formation of 3D Breast Cancer Tissues on Electrospun Chitosan/Poly(ethylene oxide) Nanofibrous Scaffolds. ACS Omega 2022, 7, 2114–2126. [CrossRef] [PubMed]   
248. Barhoum, A.; García-Betancourt, M.L.; Jeevanandam, J.; Hussien, E.A.; Mekkawy, S.A.; Mostafa, M.; Omran, M.M.; Abdalla, M.S.; Bechelany, M. Review on Natural, Incidental, Bioinspired, and Engineered Nanomaterials: History, Definitions, Classifications, Synthesis, Properties, Market, Toxicities, Risks, and Regulations. Nanomaterials 2022, 12, 177. [CrossRef] [PubMed]   
249. Besinis, A.; De Peralta, T.; Tredwin, C.J.; Handy, R.D. Review of Nanomaterials in Dentistry: Interactions with the Oral Microenvironment, Clinical Applications, Hazards, and Benefits. ACS Nano 2015, 9, 2255–2289. [CrossRef]   
250. Xi, Y.; Wang, Y.; Gao, J.; Xiao, Y.; Du, J. Dual Corona Vesicles with Intrinsic Antibacterial and Enhanced Antibiotic Delivery Capabilities for Effective Treatment of Biofilm-Induced Periodontitis. ACS Nano 2019, 13, 13645–13657. [CrossRef]   
251. Lombardi, V.R. Editorial [Exploring Neural-Immune System Interactions]. Curr. Immunol. Rev. 2012, 8, 37–38. [CrossRef]   
252. Bertram, L. The genetic epidemiology of neurodegenerative disease. J. Clin. Investig. 2005, 115, 1449–1457. [CrossRef]   
253. Faroni, A.; Mobasseri, S.A.; Kingham, P.J.; Reid, A.J. Peripheral nerve regeneration: Experimental strategies and future perspectives. Adv. Drug Deliv. Rev. 2015, 82–83, 160–167. [CrossRef]   
254. Barhoum, A.; El-Maghrabi, H.H.; Iatsunskyi, I.; Coy, E.; Renard, A.; Salameh, C.; Weber, M.; Sayegh, S.; Nada, A.; Roualdes, S.; et al. Atomic layer deposition of Pd nanoparticles on self-supported carbon-Ni/NiO-Pd nanofiber electrodes for electrochemical hydrogen and oxygen evolution reactions. J. Colloid Interface Sci. 2020, 569, 286–297. [CrossRef] [PubMed]   
255. Barhoum, A.; Rasouli, R.; Yousefzadeh, M.; Rahier, H.; Bechelany, M. Nanofiber Technologies: History and Development. In Handbook of Nanofibers; Springer International Publishing: Cham, Switzerland, 2019; pp. 3–43. [CrossRef]   
256. Barhoum, A.; Favre, T.; Sayegh, S.; Tanos, F.; Coy, E.; Iatsunskyi, I.; Razzouk, A.; Cretin, M.; Bechelany, M. 3D Self-Supported Nitrogen-Doped Carbon Nanofiber Electrodes Incorporated ${ \mathrm { C o } } / { \mathrm { C o } } { \mathrm { O } } _ { \mathrm { x } }$ Nanoparticles: Application to Dyes Degradation by Electro-Fenton-Based Process. Nanomaterials 2021, 11, 2686. [CrossRef] [PubMed]   
257. Turky, A.O.; Barhoum, A.; Rashad, M.; Bechelany, M. Enhanced the structure and optical properties for ZnO/PVP nanofibers fabricated via electrospinning technique. J. Mater. Sci. Mater. Electron. 2017, 28, 17526–17532. [CrossRef]   
258. Barhoum, A.; Jeevanandam, J.; Rastogi, A.; Samyn, P.; Boluk, Y.; Dufresne, A.; Danquah, M.K.; Bechelany, M. Plant celluloses, hemicelluloses, lignins, and volatile oils for the synthesis of nanoparticles and nanostructured materials. Nanoscale 2020, 12, 22845–22890. [CrossRef] [PubMed]   
259. Aljabali, A.A.A.; Obeid, M.A.; Al Zoubi, M.S.; Charbe, N.B.; Chellappan, D.K.; Mishra, V.; Dureja, H.; Gupta, G.; Prasher, P.; Dua, K.; et al. Nanocelluloses in Sensing Technology. In Handbook of Nanocelluloses; Springer: Cham, Switzerland, 2021; pp. 1–30. [CrossRef]   
260. Xue, J.; Pisignano, D.; Xia, Y. Maneuvering the Migration and Differentiation of Stem Cells with Electrospun Nanofibers. Adv. Sci. 2020, 7, 2000735. [CrossRef] [PubMed]   
261. Sorg, H.; Tilkorn, D.J.; Hager, S.; Hauser, J.; Mirastschijski, U. Skin Wound Healing: An Update on the Current Knowledge and Concepts. Eur. Surg. Res. 2016, 58, 81–94. [CrossRef] [PubMed]   
262. Dreifke, M.B.; Jayasuriya, A.A.; Jayasuriya, A.C. Current wound healing procedures and potential care. Mater. Sci. Eng. C 2014, 48, 651–662. [CrossRef]   
263. Pober, J.S.; Sessa, W.C. Inflammation and the blood microvascular system. Cold Spring Harb. Perspect Biol. 2014, 7, a016345. [CrossRef]   
264. Bodnar, R.J. Chemokine Regulation of Angiogenesis during Wound Healing. Adv. Wound Care 2015, 4, 641–650. [CrossRef]   
265. Mechanick, J.I. Practical aspects of nutritional support for wound-healing patients. Am. J. Surg. 2004, 188, 52–56. [CrossRef]   
266. Greer, N.; Foman, N.A.; Macdonald, R.; Dorrian, J.; Fitzgerald, P.; Rutks, I.; Wilt, T.J. Advanced Wound Care Therapies for Nonhealing Diabetic, Venous, and Arterial Ulcers. Ann. Intern. Med. 2013, 159, 532–542. [CrossRef] [PubMed]   
267. Ravichandiran, P.; Prabakaran, D.; Maroli, N.; Boguszewska-Czubara, A.; Masłyk, M.; Kim, A.R.; Chandrasekaran, B.; Yoo, D.J. Construction of a simple dual-channel fluorescence chemosensor for ${ \mathrm { C u } } ^ { 2 + }$ ion and GSSG detection and its mitochondria-targeting bioimaging applications. Anal. Chim. Acta 2021, 1181, 338896. [CrossRef] [PubMed]   
268. Randeria, P.S.; Seeger, M.A.; Wang, X.-Q.; Wilson, H.; Shipp, D.; Mirkin, C.A.; Paller, A.S. siRNA-based spherical nucleic acids reverse impaired wound healing in diabetic mice by ganglioside GM3 synthase knockdown. Proc. Natl. Acad. Sci. USA 2015, 112, 5573–5578. [CrossRef] [PubMed]   
269. Wang, P.; Lombi, E.; Zhao, F.-J.; Kopittke, P. Nanotechnology: A New Opportunity in Plant Sciences. Trends Plant Sci. 2016, 21, 699–712. [CrossRef]   
270. Rastogi, A.; Tripathi, D.K.; Yadav, S.; Chauhan, D.K.; Živˇcák, M.; Ghorbanpour, M.; El-Sheery, N.I.; Brestic, M. Application of silicon nanoparticles in agriculture. 3 Biotech 2019, 9, 90. [CrossRef]   
271. Jampílek, J.; Král’ová, K. Nanomaterials for delivery of nutrients and growth-promoting compounds to plants. In Nano-Technology; Springer: Berlin/Heidelberg, Germany, 2017; pp. 177–226.   
272. Liu, R.; Lal, R. Potentials of engineered nanoparticles as fertilizers for increasing agronomic productions. Sci. Total Environ. 2015, 514, 131–139. [CrossRef]   
273. Saharan, V.; Kumaraswamy, R.V.; Choudhary, R.C.; Kumari, S.; Pal, A.; Raliya, R.; Biswas, P. Cu-Chitosan Nanoparticle Mediated Sustainable Approach To Enhance Seedling Growth in Maize by Mobilizing Reserved Food. J. Agric. Food Chem. 2016, 64, 6148–6155. [CrossRef]   
274. Verma, S.K.; Das, A.K.; Patel, M.K.; Shah, A.; Kumar, V.; Gantait, S. Engineered nanomaterials for plant growth and development: A perspective analysis. Sci. Total Environ. 2018, 630, 1413–1435. [CrossRef]   
275. Khodakovskaya, M.V.; Kim, B.-S.; Kim, J.N.; Alimohammadi, M.; Dervishi, E.; Mustafa, T.; Cernigla, C.E. Carbon Nanotubes as Plant Growth Regulators: Effects on Tomato Growth, Reproductive System, and Soil Microbial Community. Small 2012, 9, 115–123. [CrossRef]   
276. Abdel-Aziz, H.; Hasaneen, M.N.A.; Omer, A.M. Nano chitosan-NPK fertilizer enhances the growth and productivity of wheat plants grown in sandy soil. Span. J. Agric. Res. 2016, 14, e0902. [CrossRef]   
277. Meurer, R.A.; Kemper, S.; Knopp, S.; Eichert, T.; Jakob, F.; Goldbach, H.E.; Schwaneberg, U.; Pich, A. Biofunctional Microgel-Based Fertilizers for Controlled Foliar Delivery of Nutrients to Plants. Angew. Chem. Int. Ed. 2017, 56, 7380–7386. [CrossRef] [PubMed]   
278. Shang, Y.; Hasan, M.K.; Ahammed, G.J.; Li, M.; Yin, H.; Zhou, J. Applications of Nanotechnology in Plant Growth and Crop Protection: A Review. Molecules 2019, 24, 2558. [CrossRef] [PubMed]   
279. Qureshi, A.; Singh, D.; Dwivedi, S. Nano-fertilizers: A Novel Way for Enhancing Nutrient Use Efficiency and Crop Productivity. Int. J. Curr. Microbiol. Appl. Sci. 2018, 7, 3325–3335. [CrossRef]   
280. Preetha, P.S.; Balakrishnan, N. A Review of Nano Fertilizers and Their Use and Functions in Soil. Int. J. Curr. Microbiol. Appl. Sci. 2017, 6, 3117–3133. [CrossRef]   
281. Solanki, P.; Bhargava, A.; Chhipa, H.; Jain, N.; Panwar, J. Nano-fertilizers and Their Smart Delivery System. In Nanotechnologies in Food and Agriculture; Springer: Cham, Switzerland, 2015; pp. 81–101.   
282. Subramanian, K.S.; Manikandan, A.; Thirunavukkarasu, M.; Rahale, C.S. Nano-fertilizers for Balanced Crop Nutrition. In Nanotechnologies in Food and Agriculture; Springer: Cham, Switzerland, 2015; pp. 69–80.   
283. Sanzari, I.; Leone, A.; Ambrosone, A. Nanotechnology in Plant Science: To Make a Long Story Short. Front. Bioeng. Biotechnol. 2019, 7, 120. [CrossRef] [PubMed]   
284. Park, B. Nanotechnology and the packaging of food and other fast-moving consumer goods. In Trends in Packaging of Food, Beverages and Other Fast-Moving Consumer Goods (FMCG); Woodhead Publishing Limited: Cambridge, UK, 2013; pp. 241–260. [CrossRef]   
285. Rossi, M.; Passeri, D.; Sinibaldi, A.; Angjellari, M.; Tamburri, E.; Sorbo, A.; Carata, E.; Dini, L. Nanotechnology for Food Packaging and Food Quality Assessment. In Advances in Food and Nutrition Research; Elsevier: Amsterdam, The Netherlands, 2017; pp. 149–204. [CrossRef]   
286. Contado, C. Nanomaterials in consumer products: A challenging analytical problem. Front. Chem. 2015, 3, 48. [CrossRef]   
287. Mu, L.; Droujinine, I.A.; Rajan, N.K.; Sawtelle, S.D.; Reed, M.A. Direct, Rapid, and Label-Free Detection of Enzyme–Substrate Interactions in Physiological Buffers Using CMOS-Compatible Nanoribbon Sensors. Nano Lett. 2014, 14, 5315–5322. [CrossRef]   
288. Huang, Q.; Yu, H.; Ru, Q. Bioavailability and Delivery of Nutraceuticals Using Nanotechnology. J. Food Sci. 2010, 75, R50–R57. [CrossRef]   
289. Inbaraj, B.S.; Chen, B. Nanomaterial-based sensors for detection of foodborne bacterial pathogens and toxins as well as pork adulteration in meat products. J. Food Drug Anal. 2015, 24, 15–28. [CrossRef]   
290. Jampilek, J.; Kos, J.; Kralova, K. Potential of Nanomaterial Applications in Dietary Supplements and Foods for Special Medical Purposes. Nanomaterials 2019, 9, 296. [CrossRef]   
291. Mali, S.C.; Raj, S.; Trivedi, R. Nanotechnology a novel approach to enhance crop productivity. Biochem. Biophys. Rep. 2020, 24, 100821. [CrossRef]   
292. Saifullah, M.; Shishir, M.R.I.; Ferdowsi, R.; Tanver Rahman, M.R.; Van Vuong, Q. Micro and nano encapsulation, retention and controlled release of flavor and aroma compounds: A critical review. Trends Food Sci. Technol. 2019, 86, 230–251. [CrossRef]   
293. Kumar, V.; Guleria, P.; Mehta, S.K. Nanosensors for food quality and safety assessment. Environ. Chem. Lett. 2017, 15, 165–177. [CrossRef]   
294. George, J.; Sabapathi, S.N. Cellulose nanocrystals: Synthesis, functional properties, and applications. Nanotechnol. Sci. Appl. 2015, 8, 45–54. [CrossRef] [PubMed]   
295. Vong, K.; Eda, S.; Kadota, Y.; Nasibullin, I.; Wakatake, T.; Yokoshima, S.; Shirasu, K.; Tanaka, K. An artificial metalloenzyme biosensor can detect ethylene gas in fruits and Arabidopsis leaves. Nat. Commun. 2019, 10, 5746. [CrossRef]   
296. Pateiro, M.; Gómez, B.; Munekata, P.; Barba, F.; Putnik, P.; Kovaˇcevi´c, D.; Lorenzo, J. Nanoencapsulation of Promising Bioactive Compounds to Improve Their Absorption, Stability, Functionality and the Appearance of the Final Food Products. Molecules 2021, 26, 1547. [CrossRef]   
297. Wang, L.; Hu, C.; Shao, L. The antimicrobial activity of nanoparticles: Present situation and prospects for the future. Int. J. Nanomed. 2017, 12, 1227–1249. [CrossRef]   
298. Sankar, V.R.; Reddy, Y.D. Nanocochleate—A new approach in lipid drug delivery. Int. J. Pharm. Pharm. Sci. 2010, 2, 220–223.   
299. Sekhon, B. Nanotechnology in agri-food production: An overview. Nanotechnol. Sci. Appl. 2014, 7, 31–53. [CrossRef]   
300. Prakash, J.; Vignesh, K.; Anusuya, T.; Kalaivani, T.; Ramachandran, C.; Sudha, R.R.; Rubab, M.; Khan, I.; Elahi, F.; Oh, D.-H. Ap-plication of Nanoparticles in Food Preservation and Food Processing. J. Food Hyg. Saf. 2019, 34, 317–324.   
301. Ribeiro, T.; Baleizão, C.; Farinha, J.P.S. Functional Films from Silica/Polymer Nanoparticles. Materials 2014, 7, 3881–3900. [CrossRef] [PubMed]   
302. Hsu, C.-Y.; Wang, P.-W.; Alalaiwe, A.; Lin, Z.-C.; Fang, J.-Y. Use of Lipid Nanocarriers to Improve Oral Delivery of Vitamins. Nutrients 2019, 11, 68. [CrossRef] [PubMed]   
303. Pakrashi, S.; Dalai, S.; Sabat, D.; Singh, S.; Chandrasekaran, N.; Mukherjee, A. Cytotoxicity of $\mathrm { A l } _ { 2 } \mathrm { O } _ { 3 }$ Nanoparticles at Low Exposure Levels to a Freshwater Bacterial Isolate. Chem. Res. Toxicol. 2011, 24, 1899–1904. [CrossRef] [PubMed]   
304. Park, E.-J.; Lee, G.-H.; Yoon, C.; Jeong, U.; Kim, Y.; Cho, M.-H.; Kim, D.-W. Biodistribution and toxicity of spherical aluminum oxide nanoparticles. J. Appl. Toxicol. 2015, 36, 424–433. [CrossRef] [PubMed]   
305. Minigalieva, I.A.; Katsnelson, B.A.; Privalova, L.I.; Sutunkova, M.P.; Gurvich, V.B.; Shur, V.Y.; Shishkina, E.V.; Valamina, I.E.; Makeyev, O.H.; Panov, V.G.; et al. Combined Subchronic Toxicity of Aluminum (III), Titanium (IV) and Silicon (IV) Oxide Nanoparticles and Its Alleviation with a Complex of Bioprotectors. Int. J. Mol. Sci. 2018, 19, 837. [CrossRef]   
306. Asharani, P.V.; Lianwu, Y.; Gong, Z.; Valiyaveettil, S. Comparison of the toxicity of silver, gold and platinum nanoparticles in developing zebrafish embryos. Nanotoxicology 2010, 5, 43–54. [CrossRef]   
307. Tao, C. Antimicrobial activity and toxicity of gold nanoparticles: Research progress, challenges and prospects. Lett. Appl. Microbiol. 2018, 67, 537–543. [CrossRef]   
308. Boisselier, E.; Astruc, D. Gold nanoparticles in nanomedicine: Preparations, imaging, diagnostics, therapies and toxicity. Chem. Soc. Rev. 2009, 38, 1759–1782. [CrossRef]   
309. Ahamed, M.; Siddiqui, M.; Akhtar, M.; Ahmad, I.; Pant, A.B.; Alhadlaq, H. Genotoxic potential of copper oxide nanoparticles in human lung epithelial cells. Biochem. Biophys. Res. Commun. 2010, 396, 578–583. [CrossRef]   
310. Fahmy, B.; Cormier, S.A. Copper oxide nanoparticles induce oxidative stress and cytotoxicity in airway epithelial cells. Toxicol. Vitro 2009, 23, 1365–1371. [CrossRef]   
311. Karlsson, H.L.; Gustafsson, J.; Cronholm, P.; Möller, L. Size-dependent toxicity of metal oxide particles—A comparison between nano- and micrometer size. Toxicol. Lett. 2009, 188, 112–118. [CrossRef]   
312. Lei, R.; Wu, C.; Yang, B.; Ma, H.; Shi, C.; Wang, Q.; Wang, Q.; Yuan, Y.; Liao, M. Integrated metabolomic analysis of the nano-sized copper particle-induced hepatotoxicity and nephrotoxicity in rats: A rapid in vivo screening method for nanotoxicity. Toxicol. Appl. Pharmacol. 2008, 232, 292–301. [CrossRef] [PubMed]   
313. de Lima, R.; Seabra, A.B.; Durán, N. Silver nanoparticles: A brief review of cytotoxicity and genotoxicity of chemically and biogenically synthesized nanoparticles. J. Appl. Toxicol. 2012, 32, 867–879. [CrossRef] [PubMed]   
314. Hadrup, N.; Sharma, A.K.; Loeschner, K.; Jacobsen, N.R. Pulmonary toxicity of silver vapours, nanoparticles and fine dusts: A review. Regul. Toxicol. Pharmacol. 2020, 115, 104690. [CrossRef] [PubMed]   
315. Dos Santos, C.A.; Seckler, M.; Ingle, A.P.; Gupta, I.; Galdiero, S.; Galdiero, M.; Gade, A.; Rai, M. Silver Nanoparticles: Therapeutical Uses, Toxicity, and Safety Issues. J. Pharm. Sci. 2014, 103, 1931–1944. [CrossRef]   
316. Cao, Y.; Gong, Y.; Liao, W.; Luo, Y.; Wu, C.; Wang, M.; Yang, Q. A review of cardiovascular toxicity of $\mathrm { T i O } _ { 2 } ,$ , $Z _ { \mathrm { { n C } } }$ and $\mathrm { A g }$ nanoparticles (NPs). BioMetals 2018, 31, 457–476. [CrossRef]   
317. Kumar, A.; Pandey, A.K.; Singh, S.S.; Shanker, R.; Dhawan, A. Engineered $Z _ { \mathrm { { n O } } }$ and $\mathrm { T i O } _ { 2 }$ nanoparticles induce oxidative stress and DNA damage leading to reduced viability of Escherichia coli. Free Radic. Biol. Med. 2011, 51, 1872–1881. [CrossRef] [PubMed]   
318. Subramaniam, V.D.; Prasad, S.V.; Banerjee, A.; Gopinath, M.; Murugesan, R.; Marotta, F.; Sun, X.-F.; Pathak, S. Health hazards of nanoparticles: Understanding the toxicity mechanism of nanosized $Z _ { \mathrm { n O } }$ in cosmetic products. Drug Chem. Toxicol. 2018, 42, 84–93. [CrossRef] [PubMed]   
319. Singh, S. Zinc oxide nanoparticles impacts: Cytotoxicity, genotoxicity, developmental toxicity, and neurotoxicity. Toxicol. Mech. Methods 2019, 29, 300–311. [CrossRef] [PubMed]   
320. Sun, Z.; Yathindranath, V.; Worden, M.; Thliveris, J.A.; Chu, S.; Parkinson, F.E.; Hegmann, T.; Miller, D.W. Characterization of cellular uptake and toxicity of aminosilane-coated iron oxide nanoparticles with different charges in central nervous systemrelevant cell culture models. Int. J. Nanomed. 2013, 8, 961–970. [CrossRef]   
321. Sohaebuddin, S.K.; Thevenot, P.T.; Baker, D.; Eaton, J.W.; Tang, L. Nanomaterial cytotoxicity is composition, size, and cell type dependent. Part. Fibre Toxicol. 2010, 7, 1–17. [CrossRef] [PubMed]   
322. Raghunathan, V.K.; Devey, M.; Hawkins, S.; Hails, L.; Davis, S.A.; Mann, S.; Chang, I.T.; Ingham, E.; Malhas, A.; Vaux, D.J.; et al. Influence of particle size and reactive oxygen species on cobalt chrome nanoparticle-mediated genotoxicity. Biomaterials 2013, 34, 3559–3570. [CrossRef] [PubMed]   
323. Morimoto, Y.; Horie, M.; Kobayashi, N.; Shinohara, N.; Shimada, M. Inhalation Toxicity Assessment of Carbon-Based Nanoparticles. Acc. Chem. Res. 2012, 46, 770–781. [CrossRef] [PubMed]   
324. Zhang, Y.; Petibone, D.; Xu, Y.; Mahmood, M.; Karmakar, A.; Casciano, D.; Ali, S.; Biris, A.S. Toxicity and efficacy of carbon nanotubes and graphene: The utility of carbon-based nanoparticles in nanomedicine. Drug Metab. Rev. 2014, 46, 232–246. [CrossRef] [PubMed]   
325. Fröhlich, E. Role of omics techniques in the toxicity testing of nanoparticles. J. Nanobiotechnol. 2017, 15, 1–22. [CrossRef] [PubMed]   
326. Hamimed, S.; Abdeljelil, N.; Landoulsi, A.; Chatti, A.; Aljabali, A.A.A.; Barhoum, A. Bacterial Cellulose Nanofibers. In Handbook of Nanocelluloses; Barhoum, A., Ed.; Springer: Cham, Switzerland, 2022. [CrossRef]   
327. Moodley, K.G.; Arumugam, V.; Barhoum, A. Nanocellulose-Based Materials for Wastewater Treatment. In Handbook of Nanocelluloses; Barhoum, A., Ed.; Springer: Cham, Switzerland, 2021. [CrossRef]